/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class MicrosoftSqlServerDialect
extends JdbcDialectImpl {
    private final DateFormat df = new SimpleDateFormat("yyyyMMdd");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MicrosoftSqlServerDialect.class, Dialect.DatabaseProduct.MSSQL);

    public MicrosoftSqlServerDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean requiresUnionOrderByOrdinal() {
        return false;
    }

    @Override
    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        buf.append("CONVERT(DATE, '");
        buf.append(this.df.format(date));
        buf.append("', 112)");
    }
}

