/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.recorder.ListRecorder;
import mondrian.recorder.MessageRecorder;
import mondrian.recorder.RecorderException;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.aggmatcher.DefaultRules;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import org.apache.log4j.Logger;

public class AggTableManager {
    private static final Logger LOGGER = Logger.getLogger(AggTableManager.class);
    private final RolapSchema schema;
    private static final MondrianResource mres = MondrianResource.instance();

    public AggTableManager(RolapSchema schema) {
        this.schema = schema;
    }

    public void finalCleanUp() {
        this.removeJdbcSchema();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("AggTableManager.finalCleanUp: schema=" + this.schema.getName()));
        }
    }

    public Logger getLogger() {
        return LOGGER;
    }

    public void initialize() {
        if (MondrianProperties.instance().ReadAggregates.get()) {
            try {
                this.loadRolapStarAggregates();
            }
            catch (SQLException ex) {
                throw AggTableManager.mres.AggLoadingError.ex(ex);
            }
        }
        this.printResults();
    }

    private void printResults() {
        if (this.getLogger().isDebugEnabled()) {
            StringBuilder buf = new StringBuilder(4096);
            buf.append(Util.nl);
            for (RolapStar star : this.getStars()) {
                buf.append(star.toString());
                buf.append(Util.nl);
            }
            this.getLogger().debug((Object)buf.toString());
        }
    }

    private JdbcSchema getJdbcSchema() {
        DataSource dataSource = this.schema.getInternalConnection().getDataSource();
        return JdbcSchema.makeDB(dataSource);
    }

    private void removeJdbcSchema() {
        DataSource dataSource = this.schema.getInternalConnection().getDataSource();
        JdbcSchema.removeDB(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRolapStarAggregates() throws SQLException {
        ListRecorder msgRecorder = new ListRecorder();
        try {
            JdbcSchema db;
            DefaultRules rules = DefaultRules.getInstance();
            JdbcSchema jdbcSchema = db = this.getJdbcSchema();
            synchronized (jdbcSchema) {
                db.flushUsages();
                db.load();
                for (RolapStar star : this.getStars()) {
                    star.prepareToLoadAggregates();
                    List<ExplicitRules.Group> aggGroups = this.getAggGroups(star);
                    for (ExplicitRules.Group group : aggGroups) {
                        group.validate(msgRecorder);
                    }
                    String factTableName = star.getFactTable().getAlias();
                    JdbcSchema.Table dbFactTable = db.getTable(factTableName);
                    if (dbFactTable == null) {
                        msgRecorder.reportWarning("No Table found for fact name=" + factTableName);
                        continue;
                    }
                    this.bindToStar(dbFactTable, star, msgRecorder);
                    String schema = dbFactTable.table.schema;
                    for (JdbcSchema.Table dbTable : db.getTables()) {
                        String name = dbTable.getName();
                        if (ExplicitRules.excludeTable(name, aggGroups)) continue;
                        ExplicitRules.TableDef tableDef = ExplicitRules.getIncludeByTableDef(name, aggGroups);
                        boolean makeAggStar = false;
                        int approxRowCount = Integer.MIN_VALUE;
                        if (tableDef != null) {
                            dbTable.load();
                            makeAggStar = tableDef.columnsOK(star, dbFactTable, dbTable, msgRecorder);
                            approxRowCount = tableDef.getApproxRowCount();
                        }
                        if (!makeAggStar && rules.matchesTableName(factTableName, name)) {
                            dbTable.load();
                            makeAggStar = rules.columnsOK(star, dbFactTable, dbTable, msgRecorder);
                        }
                        if (!makeAggStar) continue;
                        dbTable.setTableUsageType(JdbcSchema.TableUsageType.AGG);
                        dbTable.table = new MondrianDef.Table(schema, name, null, null);
                        AggStar aggStar = AggStar.makeAggStar(star, dbTable, msgRecorder, approxRowCount);
                        if (aggStar.getSize() > 0) {
                            star.addAggStar(aggStar);
                            continue;
                        }
                        this.getLogger().warn((Object)AggTableManager.mres.AggTableZeroSize.str(aggStar.getFactTable().getName(), factTableName));
                    }
                }
            }
        }
        catch (RecorderException ex) {
            throw new MondrianException(ex);
        }
        finally {
            msgRecorder.logInfoMessage(this.getLogger());
            msgRecorder.logWarningMessage(this.getLogger());
            msgRecorder.logErrorMessage(this.getLogger());
            if (msgRecorder.hasErrors()) {
                throw AggTableManager.mres.AggLoadingExceededErrorCount.ex(msgRecorder.getErrorCount());
            }
        }
    }

    private Collection<RolapStar> getStars() {
        return this.schema.getStars();
    }

    protected List<ExplicitRules.Group> getAggGroups(RolapStar star) {
        ArrayList<ExplicitRules.Group> aggGroups = new ArrayList<ExplicitRules.Group>();
        for (RolapCube cube : this.schema.getCubesWithStar(star)) {
            if (!cube.hasAggGroup() || !cube.getAggGroup().hasRules()) continue;
            aggGroups.add(cube.getAggGroup());
        }
        return aggGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindToStar(JdbcSchema.Table dbFactTable, RolapStar star, MessageRecorder msgRecorder) throws SQLException {
        msgRecorder.pushContextName("AggTableManager.bindToStar");
        try {
            dbFactTable.load();
            dbFactTable.setTableUsageType(JdbcSchema.TableUsageType.FACT);
            MondrianDef.Relation relation = star.getFactTable().getRelation();
            String schema = null;
            MondrianDef.Hint[] tableHints = null;
            if (relation instanceof MondrianDef.Table) {
                schema = ((MondrianDef.Table)relation).schema;
                tableHints = ((MondrianDef.Table)relation).tableHints;
            }
            String tableName = dbFactTable.getName();
            String alias = null;
            dbFactTable.table = new MondrianDef.Table(schema, tableName, alias, tableHints);
            for (JdbcSchema.Table.Column factColumn : dbFactTable.getColumns()) {
                RolapStar.Column[] rcs;
                String cname = factColumn.getName();
                for (RolapStar.Column rc : rcs = star.getFactTable().lookupColumns(cname)) {
                    if (!(rc instanceof RolapStar.Measure)) continue;
                    RolapStar.Measure rm = (RolapStar.Measure)rc;
                    JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(JdbcSchema.UsageType.MEASURE);
                    usage.setSymbolicName(rm.getName());
                    usage.setAggregator(rm.getAggregator());
                    usage.rMeasure = rm;
                }
                RolapStar.Table rTable = star.getFactTable().findTableWithLeftJoinCondition(cname);
                if (rTable != null) {
                    JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
                    usage.setSymbolicName("FOREIGN_KEY");
                    usage.rTable = rTable;
                } else {
                    RolapStar.Column rColumn = star.getFactTable().lookupColumn(cname);
                    if (rColumn != null && !(rColumn instanceof RolapStar.Measure)) {
                        JdbcSchema.Table.Column.Usage usage = factColumn.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
                        usage.setSymbolicName("FOREIGN_KEY");
                        usage.rColumn = rColumn;
                    }
                }
                if (factColumn.hasUsage() || !this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug((Object)AggTableManager.mres.UnknownFactTableColumn.str(msgRecorder.getContext(), dbFactTable.getName(), factColumn.getName()));
            }
        }
        finally {
            msgRecorder.popContextName();
        }
    }
}

