/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.QueryAxis;
import mondrian.olap.Util;
import mondrian.olap.type.TypeUtil;
import mondrian.olap4j.MondrianOlap4jCellSetMetaData;
import mondrian.olap4j.MondrianOlap4jProperty;
import org.olap4j.Axis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.metadata.Property;

class MondrianOlap4jCellSetAxisMetaData
implements CellSetAxisMetaData {
    private final QueryAxis queryAxis;
    private final MondrianOlap4jCellSetMetaData cellSetMetaData;
    private final List<Property> propertyList = new ArrayList<Property>();

    MondrianOlap4jCellSetAxisMetaData(MondrianOlap4jCellSetMetaData cellSetMetaData, QueryAxis queryAxis) {
        if (queryAxis == null) {
            queryAxis = new QueryAxis(false, null, AxisOrdinal.StandardAxisOrdinal.SLICER, QueryAxis.SubtotalVisibility.Undefined);
        }
        this.queryAxis = queryAxis;
        this.cellSetMetaData = cellSetMetaData;
        for (Id id : queryAxis.getDimensionProperties()) {
            String[] names = id.toStringArray();
            Property olap4jProperty = null;
            if (names.length == 1 && (olap4jProperty = (Property)Util.lookup(Property.StandardMemberProperty.class, names[0])) == null) {
                olap4jProperty = MondrianOlap4jProperty.MEMBER_EXTENSIONS.get(names[0]);
            }
            if (olap4jProperty == null) {
                UnresolvedFunCall call = (UnresolvedFunCall)Util.lookup(cellSetMetaData.query, id.getSegments(), true);
                olap4jProperty = new MondrianOlap4jProperty(Util.lookupProperty(((LevelExpr)call.getArg(0)).getLevel(), call.getFunName()));
            }
            this.propertyList.add(olap4jProperty);
        }
    }

    public Axis getAxisOrdinal() {
        return Axis.Factory.forOrdinal((int)this.queryAxis.getAxisOrdinal().logicalOrdinal());
    }

    public List<org.olap4j.metadata.Hierarchy> getHierarchies() {
        return this.getHierarchiesNonFilter();
    }

    private List<org.olap4j.metadata.Hierarchy> getHierarchiesNonFilter() {
        Exp exp = this.queryAxis.getSet();
        if (exp == null) {
            return Collections.emptyList();
        }
        ArrayList<org.olap4j.metadata.Hierarchy> hierarchyList = new ArrayList<org.olap4j.metadata.Hierarchy>();
        for (Hierarchy hierarchy : TypeUtil.getHierarchies(exp.getType())) {
            hierarchyList.add(this.cellSetMetaData.olap4jStatement.olap4jConnection.toOlap4j(hierarchy));
        }
        return hierarchyList;
    }

    public List<Property> getProperties() {
        return this.propertyList;
    }
}

