/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.Set;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.Resolver;

public class CustomizedFunctionTable
extends FunTableImpl {
    Set<String> supportedBuiltinFunctions;
    Set<FunDef> specialFunctions;

    public CustomizedFunctionTable(Set<String> builtinFunctions) {
        this.supportedBuiltinFunctions = builtinFunctions;
        this.specialFunctions = new HashSet<FunDef>();
    }

    public CustomizedFunctionTable(Set<String> builtinFunctions, Set<FunDef> specialFunctions) {
        this.supportedBuiltinFunctions = builtinFunctions;
        this.specialFunctions = specialFunctions;
    }

    @Override
    public void defineFunctions(FunTable.Builder builder) {
        BuiltinFunTable builtinFunTable = BuiltinFunTable.instance();
        for (String reservedWord : builtinFunTable.getReservedWords()) {
            builder.defineReserved(reservedWord);
        }
        for (Resolver resolver : builtinFunTable.getResolvers()) {
            if (!this.supportedBuiltinFunctions.contains(resolver.getName())) continue;
            builder.define(resolver);
        }
        for (FunDef funDef : this.specialFunctions) {
            builder.define(funDef);
        }
    }
}

