/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.olap.QueryPart;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class QueryAxis
extends QueryPart {
    private boolean nonEmpty;
    private boolean ordered;
    private Exp exp;
    private final AxisOrdinal axisOrdinal;
    private SubtotalVisibility subtotalVisibility;
    private final Id[] dimensionProperties;

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisOrdinal, SubtotalVisibility subtotalVisibility, Id[] dimensionProperties) {
        assert (dimensionProperties != null);
        assert (axisOrdinal != null);
        this.nonEmpty = nonEmpty || MondrianProperties.instance().EnableNonEmptyOnAllAxis.get() && !axisOrdinal.isFilter();
        this.exp = set;
        this.axisOrdinal = axisOrdinal;
        this.subtotalVisibility = subtotalVisibility;
        this.dimensionProperties = dimensionProperties;
        this.ordered = false;
    }

    public QueryAxis(boolean nonEmpty, Exp set, AxisOrdinal axisOrdinal, SubtotalVisibility subtotalVisibility) {
        this(nonEmpty, set, axisOrdinal, subtotalVisibility, new Id[0]);
    }

    public Object clone() {
        return new QueryAxis(this.nonEmpty, this.exp.clone(), this.axisOrdinal, this.subtotalVisibility, (Id[])this.dimensionProperties.clone());
    }

    static QueryAxis[] cloneArray(QueryAxis[] a) {
        QueryAxis[] a2 = new QueryAxis[a.length];
        for (int i = 0; i < a.length; ++i) {
            a2[i] = (QueryAxis)a[i].clone();
        }
        return a2;
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            this.exp.accept(visitor);
        }
        return o;
    }

    public Calc compile(ExpCompiler compiler, ResultStyle resultStyle) {
        Exp exp = this.exp;
        if (this.axisOrdinal.isFilter()) {
            exp = QueryAxis.normalizeSlicerExpression(exp);
            exp = exp.accept(compiler.getValidator());
        }
        switch (resultStyle) {
            case LIST: {
                return compiler.compileList(exp, false);
            }
            case MUTABLE_LIST: {
                return compiler.compileList(exp, true);
            }
            case ITERABLE: {
                return compiler.compileIter(exp);
            }
        }
        throw Util.unexpected(resultStyle);
    }

    private static Exp normalizeSlicerExpression(Exp exp) {
        Exp slicer = exp;
        if (slicer instanceof LevelExpr || slicer instanceof HierarchyExpr || slicer instanceof DimensionExpr) {
            slicer = new UnresolvedFunCall("DefaultMember", Syntax.Property, new Exp[]{slicer});
        }
        if (slicer != null) {
            slicer = slicer instanceof FunCall && ((FunCall)slicer).getSyntax() == Syntax.Parentheses ? new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{slicer}) : new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{new UnresolvedFunCall("()", Syntax.Parentheses, new Exp[]{slicer})});
        }
        return slicer;
    }

    public String getAxisName() {
        return this.axisOrdinal.name();
    }

    public AxisOrdinal getAxisOrdinal() {
        return this.axisOrdinal;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public Exp getSet() {
        return this.exp;
    }

    public void setSet(Exp set) {
        this.exp = set;
    }

    public void resolve(Validator validator) {
        this.exp = validator.validate(this.exp, false);
        Type type = this.exp.getType();
        if (!TypeUtil.isSet(type)) {
            if (type instanceof MemberType || type instanceof TupleType || type instanceof DimensionType || type instanceof HierarchyType) {
                this.exp = new UnresolvedFunCall("{}", Syntax.Braces, new Exp[]{this.exp});
                this.exp = validator.validate(this.exp, false);
            } else {
                throw MondrianResource.instance().MdxAxisIsNotSet.ex(this.axisOrdinal.name());
            }
        }
    }

    @Override
    public Object[] getChildren() {
        return new Object[]{this.exp};
    }

    @Override
    public void unparse(PrintWriter pw) {
        if (this.nonEmpty) {
            pw.print("NON EMPTY ");
        }
        if (this.exp != null) {
            this.exp.unparse(pw);
        }
        if (this.dimensionProperties.length > 0) {
            pw.print(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimensionProperties.length; ++i) {
                Id dimensionProperty = this.dimensionProperties[i];
                if (i > 0) {
                    pw.print(", ");
                }
                dimensionProperty.unparse(pw);
            }
        }
        if (!this.axisOrdinal.isFilter()) {
            pw.print(" ON " + this.axisOrdinal.name());
        }
    }

    public void addLevel(Level level) {
        Util.assertTrue(level != null, "addLevel needs level");
        this.exp = new UnresolvedFunCall("Crossjoin", Syntax.Function, new Exp[]{this.exp, new UnresolvedFunCall("Members", Syntax.Property, new Exp[]{new LevelExpr(level)})});
    }

    void setSubtotalVisibility(boolean bShowSubtotals) {
        this.subtotalVisibility = bShowSubtotals ? SubtotalVisibility.Show : SubtotalVisibility.Hide;
    }

    public SubtotalVisibility getSubtotalVisibility() {
        return this.subtotalVisibility;
    }

    public void resetSubtotalVisibility() {
        this.subtotalVisibility = SubtotalVisibility.Undefined;
    }

    public void validate(Validator validator) {
        if (this.axisOrdinal.isFilter() && this.exp != null) {
            this.exp = validator.validate(this.exp, false);
        }
    }

    public Id[] getDimensionProperties() {
        return this.dimensionProperties;
    }

    public static enum SubtotalVisibility {
        Undefined,
        Hide,
        Show;

    }
}

