/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Locale;
import java.util.Map;
import mondrian.olap.Annotated;
import mondrian.olap.Annotation;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import org.apache.log4j.Logger;

public abstract class OlapElementBase
implements OlapElement {
    protected String caption = null;
    protected boolean visible = true;
    private int hash;

    protected OlapElementBase() {
    }

    protected abstract Logger getLogger();

    public boolean equals(Object o) {
        return o == this || o instanceof OlapElement && this.equals((OlapElement)o);
    }

    public boolean equals(OlapElement mdxElement) {
        return mdxElement != null && this.getClass() == mdxElement.getClass() && this.getUniqueName().equalsIgnoreCase(mdxElement.getUniqueName());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.computeHashCode();
        }
        return this.hash;
    }

    protected int computeHashCode() {
        return this.getClass().hashCode() << 8 ^ this.getUniqueName().hashCode();
    }

    public String toString() {
        return this.getUniqueName();
    }

    public Object clone() {
        return this;
    }

    @Override
    public String getCaption() {
        if (this.caption != null) {
            return this.caption;
        }
        return this.getName();
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public String getLocalized(OlapElement.LocalizedProperty prop, Locale locale) {
        Annotated annotated;
        Map<String, Annotation> annotationMap;
        if (this instanceof Annotated && !(annotationMap = (annotated = (Annotated)((Object)this)).getAnnotationMap()).isEmpty()) {
            String seek = prop.name().toLowerCase() + "." + locale;
            while (true) {
                for (Map.Entry<String, Annotation> entry : annotationMap.entrySet()) {
                    if (!entry.getKey().startsWith(seek)) continue;
                    return entry.getValue().getValue().toString();
                }
                int underscore = seek.lastIndexOf(95);
                if (underscore < 0) break;
                seek = seek.substring(0, underscore - 1);
            }
        }
        switch (prop) {
            case CAPTION: {
                return this.getCaption();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
        }
        throw Util.unexpected(prop);
    }
}

