/*
 * Decompiled with CFR 0.152.
 */
package com.bitmechanic.maxq;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class DBUtil {
    private Connection conn;

    public DBUtil(String driver, String url, String username, String pw) throws Exception {
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url, username, pw);
    }

    public DBUtil(String driver, String url, Properties props) throws Exception {
        Class.forName(driver);
        this.conn = DriverManager.getConnection(url, props);
    }

    public Connection getConnection() {
        return this.conn;
    }

    public int execute(String sql) throws Exception {
        Statement stmt = this.conn.createStatement();
        int rows = stmt.executeUpdate(sql);
        stmt.close();
        return rows;
    }

    public ArrayList loadRows(String sql) throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        ArrayList<HashMap> list = new ArrayList<HashMap>();
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        while (rs.next()) {
            HashMap map = this.rsToMap(rs, meta, cols);
            list.add(map);
        }
        rs.close();
        stmt.close();
        return list;
    }

    public HashMap loadRow(String sql) throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        HashMap map = null;
        ResultSetMetaData meta = rs.getMetaData();
        int cols = meta.getColumnCount();
        if (rs.next()) {
            map = this.rsToMap(rs, meta, cols);
        }
        rs.close();
        stmt.close();
        return map;
    }

    public String loadVal(String sql) throws Exception {
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        String str = null;
        if (rs.next()) {
            str = rs.getString(1);
        }
        rs.close();
        stmt.close();
        return str;
    }

    public void close() throws Exception {
        this.conn.close();
    }

    private HashMap rsToMap(ResultSet rs, ResultSetMetaData meta, int cols) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < cols; ++i) {
            int c = i + 1;
            map.put(meta.getColumnName(c), rs.getString(c));
        }
        return map;
    }
}

