/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ConcatenateFunction
implements Function {
    private static final long serialVersionUID = 3505313019941429911L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        StringBuffer computedResult = new StringBuffer(512);
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Type type = parameters.getType(paramIdx);
            Object value = parameters.getValue(paramIdx);
            Sequence sequence = typeRegistry.convertToSequence(type, value);
            while (sequence.hasNext()) {
                LValue lValue = sequence.nextRawValue();
                TypeValuePair pair = lValue.evaluate();
                Type type1 = pair.getType();
                Object o = pair.getValue();
                String str = typeRegistry.convertToText(type1, o);
                computedResult.append(str);
            }
        }
        return new TypeValuePair(TextType.TYPE, computedResult.toString());
    }

    @Override
    public String getCanonicalName() {
        return "CONCATENATE";
    }
}

