/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.versioning;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class VersionHelper {
    private static final Log logger = LogFactory.getLog(VersionHelper.class);
    private static final ManifestCache manifestCache = new ManifestCache();
    public static final String SNAPSHOT_TOKEN = "SNAPSHOT";
    private String version;
    private String title;
    private String productId;
    private String releaseMilestone;
    private String releaseMinor;
    private String releaseMajor;
    private String releaseNumber;
    private String releasePatch;
    private String releaseBuildNumber;
    private ProjectInformation projectInformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHelper(ProjectInformation projectInformation) {
        Manifest manifest;
        block14: {
            if (projectInformation == null) {
                throw new NullPointerException();
            }
            this.projectInformation = projectInformation;
            manifest = manifestCache.get(projectInformation.getInternalName());
            if (manifest == null) {
                ClassLoader loader = projectInformation.getClass().getClassLoader();
                try {
                    Enumeration<URL> resources = loader.getResources("META-INF/MANIFEST.MF");
                    while (resources.hasMoreElements()) {
                        Attributes attr;
                        String maybeTitle;
                        URL url = resources.nextElement();
                        String urlAsText = url.toURI().toString();
                        Manifest maybeManifest = manifestCache.getByURL(urlAsText);
                        if (maybeManifest == null) {
                            try (InputStream inputStream = url.openStream();){
                                maybeManifest = new Manifest(new BufferedInputStream(inputStream));
                            }
                        }
                        if ((maybeTitle = this.getValue(attr = this.getAttributes(maybeManifest, projectInformation.getInternalName()), "Implementation-ProductID", null)) != null) {
                            manifestCache.set(maybeTitle, urlAsText, maybeManifest);
                            if (!maybeTitle.equals(projectInformation.getInternalName())) continue;
                            manifest = maybeManifest;
                            break;
                        }
                        manifestCache.set(null, urlAsText, maybeManifest);
                    }
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug((Object)("Failed to read manifest for retrieving library version information for " + projectInformation.getProductId()), (Throwable)e);
                }
            }
        }
        if (manifest != null) {
            this.init(manifest);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to create version information for " + projectInformation.getInternalName()));
            }
            this.version = "TRUNK.development";
            this.title = projectInformation.getInternalName();
            this.productId = projectInformation.getInternalName();
            this.releaseMajor = "999";
            this.releaseMinor = "999";
            this.releaseMilestone = "999";
            this.releasePatch = "0";
            this.releaseBuildNumber = SNAPSHOT_TOKEN;
            this.releaseNumber = this.createReleaseVersion();
        }
    }

    private boolean init(Manifest props) {
        try {
            Attributes attr = this.getAttributes(props, this.projectInformation.getInternalName());
            String maybeTitle = this.getValue(attr, "Implementation-ProductID", null);
            if (!ObjectUtilities.equal(this.projectInformation.getInternalName(), maybeTitle)) {
                return false;
            }
            this.title = this.getValue(attr, "Implementation-Title", maybeTitle);
            this.version = this.getValue(attr, "Implementation-Version", "");
            this.parseVersion(this.version);
            this.productId = maybeTitle;
            if (this.productId.length() == 0) {
                this.productId = this.createProductId();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void parseVersion(String version) {
        if (version == null || version.length() == 0) {
            version = "TRUNK.development";
        }
        this.releaseMajor = "999";
        this.releaseMinor = "999";
        this.releaseMilestone = "999";
        this.releasePatch = "0";
        this.releaseBuildNumber = SNAPSHOT_TOKEN;
        if (!version.startsWith("TRUNK")) {
            String implIndicator;
            String versionNumber;
            int dashPos = version.indexOf(45);
            if (dashPos != -1) {
                versionNumber = version.substring(0, dashPos);
                implIndicator = version.substring(dashPos + 1);
            } else {
                versionNumber = version;
                implIndicator = "";
            }
            if (!StringUtils.isEmpty(versionNumber)) {
                StringTokenizer tokImpl;
                StringTokenizer tokNum = new StringTokenizer(versionNumber, ".");
                if (tokNum.hasMoreTokens()) {
                    this.releaseMajor = tokNum.nextToken();
                }
                if (tokNum.hasMoreTokens()) {
                    this.releaseMinor = tokNum.nextToken();
                }
                if (tokNum.hasMoreTokens()) {
                    this.releaseMilestone = tokNum.nextToken();
                }
                if (tokNum.hasMoreTokens()) {
                    this.releasePatch = tokNum.nextToken();
                }
                if ((tokImpl = new StringTokenizer(implIndicator, ".")).hasMoreTokens()) {
                    this.releaseBuildNumber = tokImpl.nextToken();
                }
            }
        }
        this.releaseNumber = this.createReleaseVersion();
    }

    private Attributes getAttributes(Manifest props, String name) {
        Attributes attributes = props.getAttributes(name);
        if (attributes == null) {
            return props.getMainAttributes();
        }
        return attributes;
    }

    private String getValue(Attributes attrs, String name, String defaultValue) {
        String value = attrs.getValue(name);
        if (value == null) {
            return defaultValue;
        }
        return value.trim();
    }

    private String createProductId() {
        if (this.version.trim().length() == 0) {
            return this.title;
        }
        return this.title + '-' + this.version;
    }

    private String createReleaseVersion() {
        StringBuilder buffer = new StringBuilder(50);
        buffer.append(this.releaseMajor);
        buffer.append('.');
        buffer.append(this.releaseMinor);
        buffer.append('.');
        buffer.append(this.releaseMilestone);
        if (this.releasePatch.length() > 0) {
            buffer.append('-');
            buffer.append(this.releasePatch);
        }
        if (this.releaseBuildNumber.length() > 0) {
            buffer.append(" (Build ");
            buffer.append(this.releaseBuildNumber);
            buffer.append(')');
        }
        return buffer.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public String getTitle() {
        return this.title;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getReleaseMilestone() {
        return this.releaseMilestone;
    }

    public String getReleaseMinor() {
        return this.releaseMinor;
    }

    public String getReleaseMajor() {
        return this.releaseMajor;
    }

    @Deprecated
    public String getReleaseCandidateToken() {
        return "";
    }

    public String getReleasePatch() {
        return this.releasePatch;
    }

    public String getReleaseNumber() {
        return this.releaseNumber;
    }

    public String getReleaseBuildNumber() {
        return this.releaseBuildNumber;
    }

    private static class ManifestCache {
        private Map<String, Manifest> manifests = new HashMap<String, Manifest>();
        private Map<String, Manifest> manifestsByURL = new HashMap<String, Manifest>();

        public synchronized Manifest get(String title) {
            return this.manifests.get(title);
        }

        public synchronized void set(String title, String url, Manifest manifest) {
            if (title != null) {
                this.manifests.put(title, manifest);
            }
            this.manifestsByURL.put(url, manifest);
        }

        public synchronized Manifest getByURL(String url) {
            return this.manifestsByURL.get(url);
        }
    }
}

