/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public final class UrlBuilder {
    private static final Log log = LogFactory.getLog(UrlBuilder.class);

    private UrlBuilder() {
    }

    public static String generateUrl(String server, String path, String params, String fragment) throws URISyntaxException {
        if (StringUtils.isEmpty(server)) {
            throw new IllegalArgumentException("The server can not be empty");
        }
        if (StringUtils.isEmpty(path)) {
            throw new IllegalArgumentException("The path can not be empty");
        }
        String normalizedServer = server.trim();
        if (!normalizedServer.endsWith("/")) {
            normalizedServer = normalizedServer + "/";
        }
        String normalizedPath = new URI(null, null, path.trim(), null).toString();
        while ('/' == normalizedPath.charAt(0)) {
            normalizedPath = normalizedPath.substring(1);
        }
        String url = URI.create(normalizedServer + normalizedPath).toString();
        if (!StringUtils.isEmpty(params, true)) {
            url = url + '?' + params.trim();
        }
        if (!StringUtils.isEmpty(fragment)) {
            url = url + '#' + fragment;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("generateUrl(\"" + server + "\", \"" + path + "\", \"" + params + "\", \"" + fragment + "\") == \"" + url + "\""));
        }
        return url;
    }
}

