/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Closeable;

public class StopWatch
implements Closeable {
    private long elapsedTime;
    private long startTime;
    private boolean started;

    public static StopWatch startNew() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.startTime = System.nanoTime();
        this.started = true;
    }

    public void reset() {
        this.elapsedTime = 0L;
        this.startTime = System.nanoTime();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.elapsedTime += System.nanoTime() - this.startTime;
    }

    public long getElapsedTime() {
        if (this.started) {
            return this.elapsedTime + (System.nanoTime() - this.startTime);
        }
        return this.elapsedTime;
    }

    public double getElapsedMilliseconds() {
        return (float)this.getElapsedTime() / 1000000.0f;
    }

    public double getElapsedSeconds() {
        return (float)this.getElapsedTime() / 1.0E9f;
    }

    public String toString() {
        return "StopWatch={elapsedTimeInSeconds=" + this.getElapsedSeconds() + "}";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getStartMilliseconds() {
        return (float)this.getStartTime() / 1000000.0f;
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void close() {
        this.stop();
    }
}

