/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.FormattedMessage;
import org.pentaho.reporting.libraries.base.util.PerformanceLoggingStopWatch;
import org.pentaho.reporting.libraries.base.util.StopWatch;

public class LoggingStopWatch
extends StopWatch
implements PerformanceLoggingStopWatch {
    private transient Log logger;
    private Object message;
    private String tag;
    private long loggingThreshold;
    private long firstStartTime;
    private long restartCount;

    public LoggingStopWatch(String tag) {
        ArgumentNullException.validate("tag", tag);
        this.tag = tag;
    }

    public LoggingStopWatch(String tag, Object message) {
        this(tag);
        this.message = message;
    }

    public static PerformanceLoggingStopWatch startNew(String tag, Object message) {
        LoggingStopWatch loggingStopWatch = new LoggingStopWatch(tag, message);
        loggingStopWatch.start();
        return loggingStopWatch;
    }

    public static PerformanceLoggingStopWatch startNew(String tag, String pattern, Object ... message) {
        return LoggingStopWatch.startNew(tag, new FormattedMessage(pattern, message));
    }

    public static PerformanceLoggingStopWatch startNew(String tag) {
        return LoggingStopWatch.startNew(tag, null);
    }

    @Override
    public long getLoggingThreshold() {
        return this.loggingThreshold;
    }

    @Override
    public void setLoggingThreshold(long loggingThreshold) {
        this.loggingThreshold = loggingThreshold;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public Object getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(Object message) {
        this.message = message;
    }

    @Override
    public void start() {
        if (this.isStarted()) {
            return;
        }
        super.start();
        if (this.firstStartTime == 0L) {
            this.firstStartTime = super.getStartTime();
        }
        ++this.restartCount;
    }

    @Override
    public void stop(boolean pause) {
        super.stop();
        if (pause) {
            return;
        }
        if (this.getElapsedMilliseconds() < (double)this.loggingThreshold) {
            return;
        }
        if (this.firstStartTime == 0L) {
            return;
        }
        String logMessage = this.message == null ? String.format("start[%d] time[%d] tag[%s] count[%d]", this.getStartTime(), this.getElapsedTime(), this.getTag(), this.getRestartCount()) : String.format("start[%d] time[%d] tag[%s] count[%d] message[%s]", this.getStartTime(), this.getElapsedTime(), this.getTag(), this.getRestartCount(), this.getMessage());
        this.doLog(logMessage);
        this.reset();
    }

    @Override
    public long getRestartCount() {
        return this.restartCount;
    }

    @Override
    public void reset() {
        super.reset();
        this.firstStartTime = 0L;
    }

    @Override
    public long getStartTime() {
        return this.firstStartTime;
    }

    @Override
    public void stop() {
        this.stop(false);
    }

    protected void doLog(String message) {
        if (this.logger == null) {
            this.logger = LogFactory.getLog((String)(LoggingStopWatch.class.getName() + "." + this.tag));
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.debug((Object)message);
        }
    }
}

