/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www.jaxrs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.pentaho.di.job.Job;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.jaxrs.JobResource;
import org.pentaho.di.www.jaxrs.JobStatus;
import org.pentaho.di.www.jaxrs.NVPair;
import org.pentaho.di.www.jaxrs.ServerStatus;
import org.pentaho.di.www.jaxrs.TransformationResource;
import org.pentaho.di.www.jaxrs.TransformationStatus;

@Path(value="/carte")
public class CarteResource {
    public static Trans getTransformation(String id) {
        return CarteSingleton.getInstance().getTransformationMap().getTransformation(CarteResource.getCarteObjectEntry(id));
    }

    public static Job getJob(String id) {
        return CarteSingleton.getInstance().getJobMap().getJob(CarteResource.getCarteObjectEntry(id));
    }

    public static CarteObjectEntry getCarteObjectEntry(String id) {
        List<CarteObjectEntry> transList = CarteSingleton.getInstance().getTransformationMap().getTransformationObjects();
        for (CarteObjectEntry entry : transList) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        List<CarteObjectEntry> jobList = CarteSingleton.getInstance().getJobMap().getJobObjects();
        for (CarteObjectEntry entry : jobList) {
            if (!entry.getId().equals(id)) continue;
            return entry;
        }
        return null;
    }

    @GET
    @Path(value="/systemInfo")
    @Produces(value={"application/json"})
    public ServerStatus getSystemInfo() {
        ServerStatus serverStatus = new ServerStatus();
        serverStatus.setStatusDescription("Online");
        return serverStatus;
    }

    @GET
    @Path(value="/configDetails")
    @Produces(value={"application/json"})
    public List<NVPair> getConfigDetails() {
        SlaveServerConfig serverConfig = CarteSingleton.getInstance().getTransformationMap().getSlaveServerConfig();
        ArrayList<NVPair> list = new ArrayList<NVPair>();
        list.add(new NVPair("maxLogLines", "" + serverConfig.getMaxLogLines()));
        list.add(new NVPair("maxLogLinesAge", "" + serverConfig.getMaxLogTimeoutMinutes()));
        list.add(new NVPair("maxObjectsAge", "" + serverConfig.getObjectTimeoutMinutes()));
        list.add(new NVPair("configFile", "" + serverConfig.getFilename()));
        return list;
    }

    @GET
    @Path(value="/transformations")
    @Produces(value={"application/json"})
    public List<CarteObjectEntry> getTransformations() {
        List<CarteObjectEntry> transEntries = CarteSingleton.getInstance().getTransformationMap().getTransformationObjects();
        return transEntries;
    }

    @GET
    @Path(value="/transformations/detailed")
    @Produces(value={"application/json"})
    public List<TransformationStatus> getTransformationsDetails() {
        List<CarteObjectEntry> transEntries = CarteSingleton.getInstance().getTransformationMap().getTransformationObjects();
        ArrayList<TransformationStatus> details = new ArrayList<TransformationStatus>();
        TransformationResource transRes = new TransformationResource();
        for (CarteObjectEntry entry : transEntries) {
            details.add(transRes.getTransformationStatus(entry.getId()));
        }
        return details;
    }

    @GET
    @Path(value="/jobs")
    @Produces(value={"application/json"})
    public List<CarteObjectEntry> getJobs() {
        List<CarteObjectEntry> jobEntries = CarteSingleton.getInstance().getJobMap().getJobObjects();
        return jobEntries;
    }

    @GET
    @Path(value="/jobs/detailed")
    @Produces(value={"application/json"})
    public List<JobStatus> getJobsDetails() {
        List<CarteObjectEntry> jobEntries = CarteSingleton.getInstance().getJobMap().getJobObjects();
        ArrayList<JobStatus> details = new ArrayList<JobStatus>();
        JobResource jobRes = new JobResource();
        for (CarteObjectEntry entry : jobEntries) {
            details.add(jobRes.getJobStatus(entry.getId()));
        }
        return details;
    }
}

