/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringcut;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stringcut.StringCut;
import org.pentaho.di.trans.steps.stringcut.StringCutData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class StringCutMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StringCutMeta.class;
    private String[] fieldInStream;
    private String[] fieldOutStream;
    private String[] cutFrom;
    private String[] cutTo;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    public String[] getCutFrom() {
        return this.cutFrom;
    }

    public void setCutFrom(String[] cutFrom) {
        this.cutFrom = cutFrom;
    }

    public String[] getCutTo() {
        return this.cutTo;
    }

    public void setCutTo(String[] cutTo) {
        this.cutTo = cutTo;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
        this.cutTo = new String[nrkeys];
        this.cutFrom = new String[nrkeys];
    }

    @Override
    public Object clone() {
        StringCutMeta retval = (StringCutMeta)super.clone();
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            retval.fieldInStream[i] = this.fieldInStream[i];
            retval.fieldOutStream[i] = this.fieldOutStream[i];
            retval.cutTo[i] = this.cutTo[i];
            retval.cutFrom[i] = this.cutFrom[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
                this.cutFrom[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"cut_from"), (String)"");
                this.cutTo[i] = Const.NVL((String)XMLHandler.getTagValue((Node)fnode, (String)"cut_to"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"StringCutMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        int nrkeys = 0;
        this.allocate(nrkeys);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"out_stream_name", (String)this.fieldOutStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"cut_from", (String)this.cutFrom[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"cut_to", (String)this.cutTo[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int nrkeys = rep.countNrStepAttributes(id_step, "in_stream_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.fieldInStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "out_stream_name"), (String)"");
                this.cutFrom[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "cut_from"), (String)"");
                this.cutTo[i] = Const.NVL((String)rep.getStepAttributeString(id_step, i, "cut_to"), (String)"");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StringCutMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldInStream.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "in_stream_name", this.fieldInStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "out_stream_name", this.fieldOutStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "cut_from", this.cutFrom[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "cut_to", this.cutTo[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StringCutMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        for (int i = 0; i < this.fieldOutStream.length; ++i) {
            ValueMetaInterface v;
            if (!Const.isEmpty((String)this.fieldOutStream[i])) {
                v = new ValueMeta(space.environmentSubstitute(this.fieldOutStream[i]), 2);
                v.setLength(100, -1);
                v.setOrigin(name);
                inputRowMeta.addValueMeta(v);
                continue;
            }
            v = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
            if (v == null) continue;
            v.setStorageType(0);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        String error_message = "";
        boolean first = true;
        boolean error_found = false;
        if (prev == null) {
            error_message = error_message + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.NoInputReceived", (String[])new String[0]) + Const.CR;
            CheckResult cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            ValueMetaInterface v;
            String field;
            int i;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.MissingInStreamFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            CheckResult cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            first = true;
            error_found = false;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    error_message = error_message + BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0]) + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + field + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            if (this.fieldInStream.length > 0) {
                for (int idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Const.isEmpty((String)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StringCutMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{new Integer(idx + 1).toString()}), (CheckResultSourceInterface)stepinfo);
                    remarks.add((CheckResultInterface)cr);
                }
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new StringCut(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StringCutData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

