/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.streamlookup;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.streamlookup.StreamLookup;
import org.pentaho.di.trans.steps.streamlookup.StreamLookupData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class StreamLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = StreamLookupMeta.class;
    private String[] keystream;
    private String[] keylookup;
    private String[] value;
    private String[] valueName;
    private String[] valueDefault;
    private int[] valueDefaultType;
    private boolean inputSorted;
    private boolean memoryPreservationActive;
    private boolean usingSortedList;
    private boolean usingIntegerPair;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.setKeystream(new String[nrkeys]);
        this.setKeylookup(new String[nrkeys]);
        this.setValue(new String[nrvalues]);
        this.setValueName(new String[nrvalues]);
        this.setValueDefault(new String[nrvalues]);
        this.setValueDefaultType(new int[nrvalues]);
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            String lookupFromStepname = XMLHandler.getTagValue((Node)stepnode, (String)"from");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.setInputSorted("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"input_sorted")));
            this.setMemoryPreservationActive("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"preserve_memory")));
            this.setUsingSortedList("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"sorted_list")));
            this.setUsingIntegerPair("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"integer_pair")));
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrkeys = XMLHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XMLHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.getKeystream()[i] = XMLHandler.getTagValue((Node)knode, (String)"name");
                this.getKeylookup()[i] = XMLHandler.getTagValue((Node)knode, (String)"field");
            }
            for (i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.getValue()[i] = XMLHandler.getTagValue((Node)vnode, (String)"name");
                this.getValueName()[i] = XMLHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.getValueName()[i] == null) {
                    this.getValueName()[i] = this.getValue()[i];
                }
                this.getValueDefault()[i] = XMLHandler.getTagValue((Node)vnode, (String)"default");
                String dtype = XMLHandler.getTagValue((Node)vnode, (String)"type");
                this.getValueDefaultType()[i] = ValueMeta.getType((String)dtype);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getInfoStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void setDefault() {
        this.setMemoryPreservationActive(true);
        this.setUsingSortedList(false);
        this.setUsingIntegerPair(false);
        this.allocate(0, 0);
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (info != null && info.length == 1 && info[0] != null) {
            for (int i = 0; i < this.getValueName().length; ++i) {
                ValueMetaInterface v = info[0].searchValueMeta(this.getValue()[i]);
                if (v == null) {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.ReturnValueCanNotBeFound", (String[])new String[]{this.getValue()[i]}));
                }
                v.setName(this.getValueName()[i]);
                v.setOrigin(origin);
                row.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < this.getValueName().length; ++i) {
                try {
                    ValueMetaInterface v = ValueMetaFactory.createValueMeta((String)this.getValueName()[i], (int)this.getValueDefaultType()[i]);
                    v.setOrigin(origin);
                    row.addValueMeta(v);
                    continue;
                }
                catch (Exception e) {
                    throw new KettleStepException((Throwable)e);
                }
            }
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuilder retval = new StringBuilder();
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        retval.append("    ").append(XMLHandler.addTagValue((String)"from", (String)infoStream.getStepname()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"input_sorted", (boolean)this.isInputSorted()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"preserve_memory", (boolean)this.isMemoryPreservationActive()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"sorted_list", (boolean)this.isUsingSortedList()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"integer_pair", (boolean)this.isUsingIntegerPair()));
        retval.append("    <lookup>").append(Const.CR);
        for (i = 0; i < this.getKeystream().length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getKeystream()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field", (String)this.getKeylookup()[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.getValue().length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.getValue()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"rename", (String)this.getValueName()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)this.getValueDefault()[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.getValueDefaultType()[i])));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            int i;
            String lookupFromStepname = rep.getStepAttributeString(id_step, "lookup_from_step");
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            infoStream.setSubject(lookupFromStepname);
            this.setInputSorted(rep.getStepAttributeBoolean(id_step, "input_sorted"));
            this.setMemoryPreservationActive(rep.getStepAttributeBoolean(id_step, "preserve_memory"));
            this.setUsingSortedList(rep.getStepAttributeBoolean(id_step, "sorted_list"));
            this.setUsingIntegerPair(rep.getStepAttributeBoolean(id_step, "integer_pair"));
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "return_value_name");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                this.getKeystream()[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.getKeylookup()[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.getValue()[i] = rep.getStepAttributeString(id_step, i, "return_value_name");
                this.getValueName()[i] = rep.getStepAttributeString(id_step, i, "return_value_rename");
                this.getValueDefault()[i] = rep.getStepAttributeString(id_step, i, "return_value_default");
                this.getValueDefaultType()[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "return_value_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnexpecteErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
            rep.saveStepAttribute(id_transformation, id_step, "lookup_from_step", infoStream.getStepname());
            rep.saveStepAttribute(id_transformation, id_step, "input_sorted", this.isInputSorted());
            rep.saveStepAttribute(id_transformation, id_step, "preserve_memory", this.isMemoryPreservationActive());
            rep.saveStepAttribute(id_transformation, id_step, "sorted_list", this.isUsingSortedList());
            rep.saveStepAttribute(id_transformation, id_step, "integer_pair", this.isUsingIntegerPair());
            for (i = 0; i < this.getKeystream().length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_name", this.getKeystream()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "lookup_key_field", this.getKeylookup()[i]);
            }
            for (i = 0; i < this.getValue().length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_name", this.getValue()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_rename", this.getValueName()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_default", this.getValueDefault()[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "return_value_type", ValueMeta.getTypeDesc((int)this.getValueDefaultType()[i]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"StreamLookupMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        int idx;
        boolean error_found;
        String error_message;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            error_found = false;
            for (String aKeystream : this.getKeystream()) {
                idx = prev.indexOfValue(aKeystream);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + aKeystream + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFound", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.CouldNotFindFieldsFromPreviousSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (info != null && info.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingLookupData", (String[])new String[]{info.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            error_message = "";
            error_found = false;
            for (String aKeylookup : this.getKeylookup()) {
                idx = info.indexOfValue(aKeylookup);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + aKeylookup + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            for (String aValue : this.getValue()) {
                idx = info.indexOfValue(aValue);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + aValue + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundInLookupStream2", (String[])new String[0]) + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.AllFieldsFoundInTheLookupStream2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.FieldsNotFoundFromInLookupSep", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        StreamInterface infoStream = this.getStepIOMeta().getInfoStreams().get(0);
        if (infoStream.getStepMeta() == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepNotSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepIsSelected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            if (info != null) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepExist", (String[])new String[]{infoStream.getStepname()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.SourceStepDoesNotExist", (String[])new String[]{infoStream.getStepname()}), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length >= 2) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.StepReceivingInfoFromInputSteps", (String[])new String[]{input.length + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"StreamLookupMeta.CheckResult.NeedAtLeast2InputStreams", (String[])new String[]{Const.CR, Const.CR}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new StreamLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new StreamLookupData();
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            Stream stream = new Stream(StreamInterface.StreamType.INFO, null, BaseMessages.getString(PKG, (String)"StreamLookupMeta.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, null);
            this.ioMeta.addStream(stream);
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    public boolean isInputSorted() {
        return this.inputSorted;
    }

    public void setInputSorted(boolean inputSorted) {
        this.inputSorted = inputSorted;
    }

    public String[] getKeylookup() {
        return this.keylookup;
    }

    public void setKeylookup(String[] keylookup) {
        this.keylookup = keylookup;
    }

    public String[] getKeystream() {
        return this.keystream;
    }

    public void setKeystream(String[] keystream) {
        this.keystream = keystream;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String[] getValueDefault() {
        return this.valueDefault;
    }

    public void setValueDefault(String[] valueDefault) {
        this.valueDefault = valueDefault;
    }

    public int[] getValueDefaultType() {
        return this.valueDefaultType;
    }

    public void setValueDefaultType(int[] valueDefaultType) {
        this.valueDefaultType = valueDefaultType;
    }

    public String[] getValueName() {
        return this.valueName;
    }

    public void setValueName(String[] valueName) {
        this.valueName = valueName;
    }

    public boolean isMemoryPreservationActive() {
        return this.memoryPreservationActive;
    }

    public void setMemoryPreservationActive(boolean memoryPreservationActive) {
        this.memoryPreservationActive = memoryPreservationActive;
    }

    public boolean isUsingSortedList() {
        return this.usingSortedList;
    }

    public void setUsingSortedList(boolean usingSortedList) {
        this.usingSortedList = usingSortedList;
    }

    public boolean isUsingIntegerPair() {
        return this.usingIntegerPair;
    }

    public void setUsingIntegerPair(boolean usingIntegerPair) {
        this.usingIntegerPair = usingIntegerPair;
    }
}

