/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.pentahoreporting;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.step.BaseStepMetaInjection;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionEnumEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputMeta;

public class PentahoReportingOutputMetaInjection
extends BaseStepMetaInjection
implements StepMetaInjectionInterface {
    private PentahoReportingOutputMeta meta;

    public PentahoReportingOutputMetaInjection(PentahoReportingOutputMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        all.add(this.createStepMetaInjectionEntry(Entry.INPUT_FILE_FIELD));
        all.add(this.createStepMetaInjectionEntry(Entry.OUTPUT_FILE_FIELD));
        all.add(this.createStepMetaInjectionEntry(Entry.OUTPUT_PROCESSOR_TYPE));
        StepInjectionMetaEntry fieldsEntry = this.createStepMetaInjectionEntry(Entry.PARAMETERS);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = this.createStepMetaInjectionEntry(Entry.PARAMETER);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : Entry.values()) {
            if (entry.getParent() != Entry.PARAMETER) continue;
            fieldEntry.getDetails().add(this.createStepMetaInjectionEntry(entry));
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        boolean cleared = false;
        block10: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            switch (fieldsEntry) {
                case PARAMETERS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry == null || fieldEntry != Entry.PARAMETER) continue;
                        String parameter = null;
                        String fieldname = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case PARAMETER_NAME: {
                                    parameter = value;
                                    break;
                                }
                                case FIELDNAME: {
                                    fieldname = value;
                                    break;
                                }
                            }
                        }
                        if (Const.isEmpty(parameter) || Const.isEmpty(fieldname)) continue;
                        if (!cleared) {
                            this.meta.getParameterFieldMap().clear();
                            cleared = true;
                        }
                        this.meta.getParameterFieldMap().put(parameter, fieldname);
                    }
                    continue block10;
                }
                case INPUT_FILE_FIELD: {
                    this.meta.setInputFileField((String)lookFields.getValue());
                    break;
                }
                case OUTPUT_FILE_FIELD: {
                    this.meta.setOutputFileField((String)lookFields.getValue());
                    break;
                }
                case OUTPUT_PROCESSOR_TYPE: {
                    this.meta.setOutputProcessorType(PentahoReportingOutputMeta.ProcessorType.getProcessorTypeByCode((String)lookFields.getValue()));
                    break;
                }
            }
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public PentahoReportingOutputMeta getMeta() {
        return this.meta;
    }

    public class ExcelInputSheet {
        public String sheetName;
        public int startCol;
        public int startRow;

        private ExcelInputSheet(String sheetName, int startCol, int startRow) {
            this.sheetName = sheetName;
            this.startCol = startCol;
            this.startRow = startRow;
        }
    }

    private static enum Entry implements StepMetaInjectionEnumEntry
    {
        INPUT_FILE_FIELD(2, "The name of the field containing the report file path (.prpt)"),
        OUTPUT_FILE_FIELD(2, "The name of the field containing the output file name"),
        OUTPUT_PROCESSOR_TYPE(2, "The output processor type, one of PDF, PagedHtml, StreamingHtml, CSV, Excel, Excel 2007 or RTF"),
        PARAMETERS(0, "All the parameters for the report"),
        PARAMETER(0, "One parameter"),
        PARAMETER_NAME(PARAMETER, 2, "The name of the report parameter"),
        FIELDNAME(PARAMETER, 2, "The field name providing the source data");

        private int valueType;
        private String description;
        private Entry parent;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        private Entry(Entry parent, int valueType, String description) {
            this.parent = parent;
            this.valueType = valueType;
            this.description = description;
        }

        @Override
        public int getValueType() {
            return this.valueType;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }

        @Override
        public Entry getParent() {
            return this.parent;
        }
    }
}

