/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.concatfields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.concatfields.ConcatFieldsMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;

public class ConcatFieldsMetaInjection
implements StepMetaInjectionInterface {
    private ConcatFieldsMeta meta;

    public ConcatFieldsMetaInjection(ConcatFieldsMeta meta) {
        this.meta = meta;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() throws KettleException {
        Entry[] fieldsEntries;
        Entry[] topEntries;
        ArrayList<StepInjectionMetaEntry> all = new ArrayList<StepInjectionMetaEntry>();
        for (Entry topEntry : topEntries = new Entry[]{Entry.TARGET_FIELDNAME, Entry.TARGET_LENGTH, Entry.SEPARATOR, Entry.ENCLOSURE, Entry.REMOVE_FIELDS, Entry.FORCE_ENCLOSURE, Entry.DISABLE_ENCLOSURE_FIX, Entry.HEADER, Entry.FOOTER, Entry.ENCODING, Entry.RIGHT_PAD_FIELDS, Entry.FAST_DATA_DUMP, Entry.SPLIT_EVERY, Entry.ADD_ENDING_LINE}) {
            all.add(new StepInjectionMetaEntry(topEntry.name(), topEntry.getValueType(), topEntry.getDescription()));
        }
        StepInjectionMetaEntry fieldsEntry = new StepInjectionMetaEntry(Entry.CONCAT_FIELDS.name(), 0, Entry.CONCAT_FIELDS.description);
        all.add(fieldsEntry);
        StepInjectionMetaEntry fieldEntry = new StepInjectionMetaEntry(Entry.CONCAT_FIELD.name(), 0, Entry.CONCAT_FIELD.description);
        fieldsEntry.getDetails().add(fieldEntry);
        for (Entry entry : fieldsEntries = new Entry[]{Entry.CONCAT_FIELDNAME, Entry.CONCAT_TYPE, Entry.CONCAT_LENGTH, Entry.CONCAT_FORMAT, Entry.CONCAT_PRECISION, Entry.CONCAT_CURRENCY, Entry.CONCAT_DECIMAL, Entry.CONCAT_GROUP, Entry.CONCAT_TRIM, Entry.CONCAT_NULL}) {
            StepInjectionMetaEntry metaEntry = new StepInjectionMetaEntry(entry.name(), entry.getValueType(), entry.getDescription());
            fieldEntry.getDetails().add(metaEntry);
        }
        return all;
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> all) throws KettleException {
        ArrayList<String> concatFields = new ArrayList<String>();
        ArrayList<String> concatTypes = new ArrayList<String>();
        ArrayList<String> concatLengths = new ArrayList<String>();
        ArrayList<String> concatFormats = new ArrayList<String>();
        ArrayList<String> concatPrecisions = new ArrayList<String>();
        ArrayList<String> concatCurrencies = new ArrayList<String>();
        ArrayList<String> concatDecimals = new ArrayList<String>();
        ArrayList<String> concatGroups = new ArrayList<String>();
        ArrayList<String> concatTrims = new ArrayList<String>();
        ArrayList<String> concatNulls = new ArrayList<String>();
        block29: for (StepInjectionMetaEntry lookFields : all) {
            Entry fieldsEntry = Entry.findEntry(lookFields.getKey());
            if (fieldsEntry == null) continue;
            String lookValue = (String)lookFields.getValue();
            switch (fieldsEntry) {
                case CONCAT_FIELDS: {
                    for (StepInjectionMetaEntry lookField : lookFields.getDetails()) {
                        Entry fieldEntry = Entry.findEntry(lookField.getKey());
                        if (fieldEntry != Entry.CONCAT_FIELD) continue;
                        String concatFieldname = null;
                        String concatType = null;
                        String concatLength = null;
                        String concatFormat = null;
                        String concatPrecision = null;
                        String concatCurrency = null;
                        String concatDecimal = null;
                        String concatGroup = null;
                        String concatTrim = null;
                        String concatNull = null;
                        List<StepInjectionMetaEntry> entries = lookField.getDetails();
                        for (StepInjectionMetaEntry entry : entries) {
                            Entry metaEntry = Entry.findEntry(entry.getKey());
                            if (metaEntry == null) continue;
                            String value = (String)entry.getValue();
                            switch (metaEntry) {
                                case CONCAT_FIELDNAME: {
                                    concatFieldname = value;
                                    break;
                                }
                                case CONCAT_TYPE: {
                                    concatType = value;
                                    break;
                                }
                                case CONCAT_LENGTH: {
                                    concatLength = value;
                                    break;
                                }
                                case CONCAT_FORMAT: {
                                    concatFormat = value;
                                    break;
                                }
                                case CONCAT_PRECISION: {
                                    concatPrecision = value;
                                    break;
                                }
                                case CONCAT_CURRENCY: {
                                    concatCurrency = value;
                                    break;
                                }
                                case CONCAT_DECIMAL: {
                                    concatDecimal = value;
                                    break;
                                }
                                case CONCAT_GROUP: {
                                    concatGroup = value;
                                    break;
                                }
                                case CONCAT_TRIM: {
                                    concatTrim = value;
                                    break;
                                }
                                case CONCAT_NULL: {
                                    concatNull = value;
                                    break;
                                }
                            }
                        }
                        concatFields.add(concatFieldname);
                        concatTypes.add(concatType);
                        concatLengths.add(concatLength);
                        concatFormats.add(concatFormat);
                        concatPrecisions.add(concatPrecision);
                        concatCurrencies.add(concatCurrency);
                        concatDecimals.add(concatDecimal);
                        concatGroups.add(concatGroup);
                        concatTrims.add(concatTrim);
                        concatNulls.add(concatNull);
                    }
                    continue block29;
                }
                case TARGET_FIELDNAME: {
                    this.meta.setTargetFieldName(lookValue);
                    break;
                }
                case TARGET_LENGTH: {
                    this.meta.setTargetFieldLength(Const.toInt((String)lookValue, (int)0));
                    break;
                }
                case SEPARATOR: {
                    this.meta.setSeparator(lookValue);
                    break;
                }
                case ENCLOSURE: {
                    this.meta.setEnclosure(lookValue);
                    break;
                }
                case REMOVE_FIELDS: {
                    this.meta.setRemoveSelectedFields("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FORCE_ENCLOSURE: {
                    this.meta.setEnclosureForced("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case DISABLE_ENCLOSURE_FIX: {
                    this.meta.setEnclosureFixDisabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case HEADER: {
                    this.meta.setHeaderEnabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FOOTER: {
                    this.meta.setFooterEnabled("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case ENCODING: {
                    this.meta.setEncoding(lookValue);
                    break;
                }
                case RIGHT_PAD_FIELDS: {
                    this.meta.setPadded("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case FAST_DATA_DUMP: {
                    this.meta.setFastDump("Y".equalsIgnoreCase(lookValue));
                    break;
                }
                case SPLIT_EVERY: {
                    this.meta.setSplitEvery(Const.toInt((String)lookValue, (int)0));
                    break;
                }
                case ADD_ENDING_LINE: {
                    this.meta.setEndedLine(lookValue);
                    break;
                }
            }
        }
        if (concatFields.size() > 0) {
            TextFileField[] tff = new TextFileField[concatFields.size()];
            Iterator iConcatFields = concatFields.iterator();
            Iterator iConcatTypes = concatTypes.iterator();
            Iterator iConcatLengths = concatLengths.iterator();
            Iterator iConcatFormats = concatFormats.iterator();
            Iterator iConcatPrecisions = concatPrecisions.iterator();
            Iterator iConcatCurrencies = concatCurrencies.iterator();
            Iterator iConcatDecimals = concatDecimals.iterator();
            Iterator iConcatGroups = concatGroups.iterator();
            Iterator iConcatTrims = concatTrims.iterator();
            Iterator iConcatNulls = concatNulls.iterator();
            int i = 0;
            while (iConcatFields.hasNext()) {
                TextFileField field = new TextFileField();
                field.setName((String)iConcatFields.next());
                field.setType(ValueMeta.getType((String)((String)iConcatTypes.next())));
                field.setFormat((String)iConcatFormats.next());
                field.setLength(Const.toInt((String)((String)iConcatLengths.next()), (int)-1));
                field.setPrecision(Const.toInt((String)((String)iConcatPrecisions.next()), (int)-1));
                field.setCurrencySymbol((String)iConcatCurrencies.next());
                field.setDecimalSymbol((String)iConcatDecimals.next());
                field.setGroupingSymbol((String)iConcatGroups.next());
                field.setNullString((String)iConcatNulls.next());
                field.setTrimType(ValueMeta.getTrimTypeByDesc((String)((String)iConcatTrims.next())));
                tff[i] = field;
                ++i;
            }
            this.meta.setOutputFields(tff);
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }

    public ConcatFieldsMeta getMeta() {
        return this.meta;
    }

    private static enum Entry {
        TARGET_FIELDNAME(2, "The target field name"),
        TARGET_LENGTH(2, "The length of the target field"),
        SEPARATOR(2, "The separator"),
        ENCLOSURE(2, "The enclosure"),
        REMOVE_FIELDS(2, "Remove selected fields? (Y/N)"),
        FORCE_ENCLOSURE(2, "Force the enclosure around fields? (Y/N)"),
        DISABLE_ENCLOSURE_FIX(2, "Disable the enclosure fix? (Y/N)"),
        HEADER(2, "Include header row? (Y/N)"),
        FOOTER(2, "Include footer row? (Y/N)"),
        ENCODING(2, "Encoding type (for allowed values see: http://wiki.pentaho.com/display/EAI/Concat+Fields)"),
        RIGHT_PAD_FIELDS(2, "Right pad fields? (Y/N)"),
        FAST_DATA_DUMP(2, "Fast data dump? (Y/N)"),
        SPLIT_EVERY(2, "Split every ... rows"),
        ADD_ENDING_LINE(2, "Add ending line after last row"),
        CONCAT_FIELDS(0, "The fields to concatenate"),
        CONCAT_FIELD(0, "One field to concatenate"),
        CONCAT_FIELDNAME(2, "Field to concatenate"),
        CONCAT_TYPE(2, "Field type (for allowed values see: http://wiki.pentaho.com/display/EAI/Concat+Fields)"),
        CONCAT_FORMAT(2, "Field format"),
        CONCAT_LENGTH(2, "Field length"),
        CONCAT_PRECISION(2, "Field precision"),
        CONCAT_CURRENCY(2, "Field currency symbol"),
        CONCAT_DECIMAL(2, "Field decimal symbol"),
        CONCAT_GROUP(2, "Field grouping symbol"),
        CONCAT_TRIM(2, "Field trim type (none,left,both,right)"),
        CONCAT_NULL(2, "Value to replace nulls with");

        private int valueType;
        private String description;

        private Entry(int valueType, String description) {
            this.valueType = valueType;
            this.description = description;
        }

        public int getValueType() {
            return this.valueType;
        }

        public String getDescription() {
            return this.description;
        }

        public static Entry findEntry(String key) {
            return Entry.valueOf(key);
        }
    }
}

