/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.addsequence;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.addsequence.AddSequence;
import org.pentaho.di.trans.steps.addsequence.AddSequenceData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class AddSequenceMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AddSequenceMeta.class;
    private String valuename;
    private boolean useDatabase;
    private DatabaseMeta database;
    private String schemaName;
    private String sequenceName;
    private boolean useCounter;
    private String counterName;
    private String startAt;
    private String incrementBy;
    private String maxValue;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta connection) {
        this.database = connection;
    }

    public String getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(String incrementBy) {
        this.incrementBy = incrementBy;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = Long.toString(maxValue);
    }

    public void setStartAt(long startAt) {
        this.startAt = Long.toString(startAt);
    }

    public void setIncrementBy(long incrementBy) {
        this.incrementBy = Long.toString(incrementBy);
    }

    public String getStartAt() {
        return this.startAt;
    }

    public void setStartAt(String startAt) {
        this.startAt = startAt;
    }

    public boolean isCounterUsed() {
        return this.useCounter;
    }

    public void setUseCounter(boolean useCounter) {
        this.useCounter = useCounter;
    }

    public boolean isDatabaseUsed() {
        return this.useDatabase;
    }

    public void setUseDatabase(boolean useDatabase) {
        this.useDatabase = useDatabase;
    }

    public String getValuename() {
        return this.valuename;
    }

    public void setValuename(String valuename) {
        this.valuename = valuename;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.valuename = XMLHandler.getTagValue((Node)stepnode, (String)"valuename");
            this.useDatabase = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_database"));
            String conn = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.database = DatabaseMeta.findDatabase(databases, (String)conn);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.sequenceName = XMLHandler.getTagValue((Node)stepnode, (String)"seqname");
            this.useCounter = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_counter"));
            this.counterName = XMLHandler.getTagValue((Node)stepnode, (String)"counter_name");
            this.startAt = XMLHandler.getTagValue((Node)stepnode, (String)"start_at");
            this.incrementBy = XMLHandler.getTagValue((Node)stepnode, (String)"increment_by");
            this.maxValue = XMLHandler.getTagValue((Node)stepnode, (String)"max_value");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"AddSequenceMeta.Exception.ErrorLoadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.valuename = "valuename";
        this.useDatabase = false;
        this.schemaName = "";
        this.sequenceName = "SEQ_";
        this.database = null;
        this.useCounter = true;
        this.counterName = null;
        this.startAt = "1";
        this.incrementBy = "1";
        this.maxValue = "999999999";
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v = new ValueMeta(this.valuename, 5);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("      ").append(XMLHandler.addTagValue((String)"valuename", (String)this.valuename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_database", (boolean)this.useDatabase));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"seqname", (String)this.sequenceName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"use_counter", (boolean)this.useCounter));
        retval.append("      ").append(XMLHandler.addTagValue((String)"counter_name", (String)this.counterName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"start_at", (String)this.startAt));
        retval.append("      ").append(XMLHandler.addTagValue((String)"increment_by", (String)this.incrementBy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"max_value", (String)this.maxValue));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.valuename = rep.getStepAttributeString(id_step, "valuename");
            this.useDatabase = rep.getStepAttributeBoolean(id_step, "use_database");
            this.database = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.sequenceName = rep.getStepAttributeString(id_step, "seqname");
            this.useCounter = rep.getStepAttributeBoolean(id_step, "use_counter");
            this.counterName = rep.getStepAttributeString(id_step, "counter_name");
            this.startAt = rep.getStepAttributeString(id_step, "start_at");
            this.incrementBy = rep.getStepAttributeString(id_step, "increment_by");
            this.maxValue = rep.getStepAttributeString(id_step, "max_value");
            if (this.startAt == null) {
                long start = rep.getStepAttributeInteger(id_step, "start_at");
                this.startAt = Long.toString(start);
            }
            if (this.incrementBy == null) {
                long increment = rep.getStepAttributeInteger(id_step, "increment_by");
                this.incrementBy = Long.toString(increment);
            }
            if (this.maxValue == null) {
                long max = rep.getStepAttributeInteger(id_step, "max_value");
                this.maxValue = Long.toString(max);
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AddSequenceMeta.Exception.UnableToReadStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "valuename", this.valuename);
            rep.saveStepAttribute(id_transformation, id_step, "use_database", this.useDatabase);
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.database);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "seqname", this.sequenceName);
            rep.saveStepAttribute(id_transformation, id_step, "use_counter", this.useCounter);
            rep.saveStepAttribute(id_transformation, id_step, "counter_name", this.counterName);
            rep.saveStepAttribute(id_transformation, id_step, "start_at", this.startAt);
            rep.saveStepAttribute(id_transformation, id_step, "increment_by", this.incrementBy);
            rep.saveStepAttribute(id_transformation, id_step, "max_value", this.maxValue);
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"AddSequenceMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.useDatabase) {
            Database db = new Database(loggingObject, this.database);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                db.connect();
                cr = db.checkSequenceExists(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.sequenceName)) ? new CheckResult(1, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.SequenceExists.Title", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.SequenceCouldNotBeFound.Title", (String[])new String[]{this.sequenceName}), (CheckResultSourceInterface)stepMeta);
            }
            catch (KettleException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.UnableToConnectDB.Title", (String[])new String[0]) + Const.CR + e.getMessage(), (CheckResultSourceInterface)stepMeta);
            }
            finally {
                db.disconnect();
            }
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.StepIsReceving.Title", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddSequenceMeta.CheckResult.NoInputReceived.Title", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.database, null);
        if (this.useDatabase) {
            if (this.database != null) {
                Database db = new Database(loggingObject, this.database);
                db.shareVariablesWith((VariableSpace)transMeta);
                try {
                    db.connect();
                    if (!db.checkSequenceExists(this.schemaName, this.sequenceName)) {
                        String cr_table = db.getCreateSequenceStatement(this.sequenceName, this.startAt, this.incrementBy, this.maxValue, true);
                        retval.setSQL(cr_table);
                    }
                    retval.setSQL(null);
                }
                catch (KettleException e) {
                    retval.setError(BaseMessages.getString(PKG, (String)"AddSequenceMeta.ErrorMessage.UnableToConnectDB", (String[])new String[0]) + Const.CR + e.getMessage());
                }
                finally {
                    db.disconnect();
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"AddSequenceMeta.ErrorMessage.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AddSequence(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new AddSequenceData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.database != null) {
            return new DatabaseMeta[]{this.database};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getCounterName() {
        return this.counterName;
    }

    public void setCounterName(String counterName) {
        this.counterName = counterName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }
}

