/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreDependenciesExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementExistException;
import org.pentaho.metastore.api.exceptions.MetaStoreElementTypeExistsException;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.api.exceptions.MetaStoreNamespaceExistsException;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;

public class SharedObjectsMetaStore
extends MemoryMetaStore
implements IMetaStore {
    protected IMetaStoreElementType databaseElementType;
    protected SharedObjects sharedObjects;

    public SharedObjectsMetaStore(SharedObjects sharedObjects) throws MetaStoreException {
        this.sharedObjects = sharedObjects;
        this.databaseElementType = DatabaseMetaStoreUtil.populateDatabaseElementType((IMetaStore)this);
    }

    public List<String> getNamespaces() throws MetaStoreException {
        return Arrays.asList("pentaho");
    }

    public void createNamespace(String namespace) throws MetaStoreException, MetaStoreNamespaceExistsException {
        throw new MetaStoreException("The shared objects metadata store doesn't support creating namespaces");
    }

    public void deleteNamespace(String namespace) throws MetaStoreException, MetaStoreDependenciesExistsException {
        throw new MetaStoreException("The shared objects metadata store doesn't support deleting namespaces");
    }

    public boolean namespaceExists(String namespace) throws MetaStoreException {
        return this.getNamespaces().indexOf(namespace) >= 0;
    }

    public List<IMetaStoreElementType> getElementTypes(String namespace) throws MetaStoreException {
        return Arrays.asList(this.databaseElementType);
    }

    public List<String> getElementTypeIds(String namespace) throws MetaStoreException {
        return Arrays.asList(this.databaseElementType.getId());
    }

    public IMetaStoreElementType getElementType(String namespace, String elementTypeId) throws MetaStoreException {
        if (elementTypeId.equals(this.databaseElementType.getId())) {
            return this.databaseElementType;
        }
        return null;
    }

    public IMetaStoreElementType getElementTypeByName(String namespace, String elementTypeName) throws MetaStoreException {
        for (IMetaStoreElementType elementType : this.getElementTypes(namespace)) {
            if (elementType.getName() == null || !elementType.getName().equalsIgnoreCase(elementTypeName)) continue;
            return elementType;
        }
        return null;
    }

    public void createElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreElementTypeExistsException {
        throw new MetaStoreException("The shared objects metadata store doesn't support creating new element types");
    }

    public void updateElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        throw new MetaStoreException("The shared objects metadata store doesn't support updating element types");
    }

    public void deleteElementType(String namespace, IMetaStoreElementType elementType) throws MetaStoreException, MetaStoreDependenciesExistsException {
        throw new MetaStoreException("The shared objects metadata store doesn't support deleting element types");
    }

    public List<IMetaStoreElement> getElements(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<IMetaStoreElement> list = new ArrayList<IMetaStoreElement>();
        for (SharedObjectInterface sharedObject : this.sharedObjects.getObjectsMap().values()) {
            if (!(sharedObject instanceof DatabaseMeta) || !this.databaseElementType.getName().equals(elementType.getName())) continue;
            list.add(DatabaseMetaStoreUtil.populateDatabaseElement((IMetaStore)this, (DatabaseMeta)((DatabaseMeta)sharedObject)));
        }
        return list;
    }

    public List<String> getElementIds(String namespace, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<String> ids = new ArrayList<String>();
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            ids.add(element.getId());
        }
        return ids;
    }

    public IMetaStoreElement getElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            if (!element.getId().equals(elementId)) continue;
            return element;
        }
        return null;
    }

    public IMetaStoreElement getElementByName(String namespace, IMetaStoreElementType elementType, String name) throws MetaStoreException {
        for (IMetaStoreElement element : this.getElements(namespace, elementType)) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public void createElement(String namespace, IMetaStoreElementType elementType, IMetaStoreElement element) throws MetaStoreException, MetaStoreElementExistException {
        try {
            IMetaStoreElement exists = this.getElementByName(namespace, elementType, element.getId());
            if (exists != null) {
                throw new MetaStoreException("The shared objects meta store already contains an element with type name '" + elementType.getName() + "' and element name '" + element.getName());
            }
            if (elementType.getName().equals(this.databaseElementType.getName())) {
                this.sharedObjects.storeObject((SharedObjectInterface)DatabaseMetaStoreUtil.loadDatabaseMetaFromDatabaseElement((IMetaStore)this, (IMetaStoreElement)element));
                this.sharedObjects.saveToFile();
                return;
            }
            throw new MetaStoreException("Storing elements with element type name '" + elementType.getName() + "' is not supported in the shared objects meta store");
        }
        catch (Exception e) {
            throw new MetaStoreException("Unexpected error creating an element in the shared objects meta store", (Throwable)e);
        }
    }

    public void deleteElement(String namespace, IMetaStoreElementType elementType, String elementId) throws MetaStoreException {
        try {
            if (elementType.getName().equals(this.databaseElementType.getName())) {
                this.sharedObjects.removeObject((SharedObjectInterface)DatabaseMetaStoreUtil.loadDatabaseMetaFromDatabaseElement((IMetaStore)this, (IMetaStoreElement)this.getElement(namespace, elementType, elementId)));
                this.sharedObjects.saveToFile();
                return;
            }
        }
        catch (Exception e) {
            throw new MetaStoreException("Unexpected error deleting an element in the shared objects meta store", (Throwable)e);
        }
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public void setSharedObjects(SharedObjects sharedObjects) {
        this.sharedObjects = sharedObjects;
    }
}

