/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ping;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryPing
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryPing.class;
    private String hostname = null;
    private String timeout;
    public String defaultTimeOut = "3000";
    private String nbrPackets = "2";
    private String Windows_CHAR = "-n";
    private String NIX_CHAR = "-c";
    public String classicPing = "classicPing";
    public int iclassicPing = 0;
    public String systemPing = "systemPing";
    public int isystemPing = 1;
    public String bothPings = "bothPings";
    public int ibothPings = 2;
    public String pingtype = this.classicPing;
    public int ipingtype;

    public JobEntryPing(String n) {
        super(n, "");
        this.timeout = this.defaultTimeOut;
    }

    public JobEntryPing() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryPing je = (JobEntryPing)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nbr_packets", (String)this.nbrPackets));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nbrpaquets", (String)this.nbrPackets));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"pingtype", (String)this.pingtype));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.hostname = XMLHandler.getTagValue((Node)entrynode, (String)"hostname");
            this.nbrPackets = XMLHandler.getTagValue((Node)entrynode, (String)"nbr_packets");
            String nbrPaquets = XMLHandler.getTagValue((Node)entrynode, (String)"nbrpaquets");
            if (this.nbrPackets == null && nbrPaquets != null) {
                this.nbrPackets = nbrPaquets;
            }
            this.timeout = XMLHandler.getTagValue((Node)entrynode, (String)"timeout");
            this.pingtype = XMLHandler.getTagValue((Node)entrynode, (String)"pingtype");
            if (Const.isEmpty((String)this.pingtype)) {
                this.pingtype = this.classicPing;
                this.ipingtype = this.iclassicPing;
            } else {
                this.ipingtype = this.pingtype.equals(this.systemPing) ? this.isystemPing : (this.pingtype.equals(this.bothPings) ? this.ibothPings : this.iclassicPing);
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'ping' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.hostname = rep.getJobEntryAttributeString(id_jobentry, "hostname");
            this.nbrPackets = rep.getJobEntryAttributeString(id_jobentry, "nbr_packets");
            String nbrPaquets = rep.getJobEntryAttributeString(id_jobentry, "nbrpaquets");
            if (this.nbrPackets == null && nbrPaquets != null) {
                this.nbrPackets = nbrPaquets;
            }
            this.timeout = rep.getJobEntryAttributeString(id_jobentry, "timeout");
            this.pingtype = rep.getJobEntryAttributeString(id_jobentry, "pingtype");
            if (Const.isEmpty((String)this.pingtype)) {
                this.pingtype = this.classicPing;
                this.ipingtype = this.iclassicPing;
            } else {
                this.ipingtype = this.pingtype.equals(this.systemPing) ? this.isystemPing : (this.pingtype.equals(this.bothPings) ? this.ibothPings : this.iclassicPing);
            }
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'ping' exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "hostname", this.hostname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nbr_packets", this.nbrPackets);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nbrpaquets", this.nbrPackets);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "pingtype", this.pingtype);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ping' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getNbrPackets() {
        return this.nbrPackets;
    }

    public String getRealNbrPackets() {
        return this.environmentSubstitute(this.getNbrPackets());
    }

    public void setNbrPackets(String nbrPackets) {
        this.nbrPackets = nbrPackets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealHostname() {
        return this.environmentSubstitute(this.getHostname());
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public String getRealTimeOut() {
        return this.environmentSubstitute(this.getTimeOut());
    }

    public void setTimeOut(String timeout) {
        this.timeout = timeout;
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String hostname = this.getRealHostname();
        int timeoutInt = Const.toInt((String)this.getRealTimeOut(), (int)300);
        int packets = Const.toInt((String)this.getRealNbrPackets(), (int)2);
        boolean status = false;
        if (Const.isEmpty((String)hostname)) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPing.SpecifyHost.Label", (String[])new String[0]));
            return result;
        }
        try {
            if (this.ipingtype == this.isystemPing || this.ipingtype == this.ibothPings) {
                status = this.systemPing(hostname, timeoutInt);
                if (status) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.SystemPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobPing.OK.Label", (String[])new String[]{hostname})});
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"JobPing.SystemPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobPing.NOK.Label", (String[])new String[]{hostname})});
                }
            }
            if (this.ipingtype == this.iclassicPing || this.ipingtype == this.ibothPings && !status) {
                status = this.classicPing(hostname, packets);
                if (status) {
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.ClassicPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobPing.OK.Label", (String[])new String[]{hostname})});
                    }
                } else {
                    this.log.logError(BaseMessages.getString(PKG, (String)"JobPing.ClassicPing", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"JobPing.NOK.Label", (String[])new String[]{hostname})});
                }
            }
        }
        catch (Exception ex) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPing.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        if (status) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.OK.Label", (String[])new String[]{hostname}));
            }
            result.setNrErrors(0L);
            result.setResult(true);
        } else {
            this.logError(BaseMessages.getString(PKG, (String)"JobPing.NOK.Label", (String[])new String[]{hostname}));
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    private boolean systemPing(String hostname, int timeout) {
        boolean retval = false;
        InetAddress address = null;
        try {
            address = InetAddress.getByName(hostname);
            if (address == null) {
                this.logError(BaseMessages.getString(PKG, (String)"JobPing.CanNotGetAddress", (String[])new String[]{hostname}));
                return retval;
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.HostName", (String[])new String[]{address.getHostName()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.HostAddress", (String[])new String[]{address.getHostAddress()}));
            }
            retval = address.isReachable(timeout);
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPing.ErrorSystemPing", (String[])new String[]{hostname, e.getMessage()}));
        }
        return retval;
    }

    private boolean classicPing(String hostname, int nrpackets) {
        boolean retval = false;
        try {
            String lignePing = "";
            String CmdPing = "ping ";
            CmdPing = Const.isWindows() ? CmdPing + hostname + " " + this.Windows_CHAR + " " + nrpackets : CmdPing + hostname + " " + this.NIX_CHAR + " " + nrpackets;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.NbrPackets.Label", (String[])new String[]{"" + nrpackets}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.ExecClassicPing.Label", (String[])new String[]{CmdPing}));
            }
            Process processPing = Runtime.getRuntime().exec(CmdPing);
            try {
                processPing.waitFor();
            }
            catch (InterruptedException e) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.ClassicPingInterrupted", (String[])new String[0]));
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobPing.Gettingresponse.Label", (String[])new String[]{hostname}));
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(processPing.getInputStream()));
            while ((lignePing = br.readLine()) != null) {
                if (!this.log.isDetailed()) continue;
                this.logDetailed(lignePing);
            }
            if (processPing.exitValue() == 0) {
                retval = true;
            }
        }
        catch (IOException ex) {
            this.logError(BaseMessages.getString(PKG, (String)"JobPing.Error.Label", (String[])new String[0]) + ex.getMessage());
        }
        return retval;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.hostname)) {
            String realServername = jobMeta.environmentSubstitute(this.hostname);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "hostname", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

