/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.io.IOException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobConfiguration {
    public static final String XML_TAG = "job_configuration";
    private JobMeta jobMeta;
    private JobExecutionConfiguration jobExecutionConfiguration;

    public JobConfiguration(JobMeta jobMeta, JobExecutionConfiguration jobExecutionConfiguration) {
        this.jobMeta = jobMeta;
        this.jobExecutionConfiguration = jobExecutionConfiguration;
    }

    public String getXML() throws IOException {
        StringBuffer xml = new StringBuffer();
        xml.append("<job_configuration>").append(Const.CR);
        xml.append(this.jobMeta.getXML());
        xml.append(this.jobExecutionConfiguration.getXML());
        xml.append("</job_configuration>").append(Const.CR);
        return xml.toString();
    }

    public JobConfiguration(Node configNode) throws KettleException {
        Node jobNode = XMLHandler.getSubNode((Node)configNode, (String)"job");
        Node trecNode = XMLHandler.getSubNode((Node)configNode, (String)"job_execution_configuration");
        this.jobExecutionConfiguration = new JobExecutionConfiguration(trecNode);
        this.jobMeta = new JobMeta(jobNode, this.jobExecutionConfiguration.getRepository(), null);
    }

    public static final JobConfiguration fromXML(String xml) throws KettleException {
        Document document = XMLHandler.loadXMLString((String)xml);
        Node configNode = XMLHandler.getSubNode((Node)document, (String)XML_TAG);
        return new JobConfiguration(configNode);
    }

    public JobExecutionConfiguration getJobExecutionConfiguration() {
        return this.jobExecutionConfiguration;
    }

    public void setJobExecutionConfiguration(JobExecutionConfiguration jobExecutionConfiguration) {
        this.jobExecutionConfiguration = jobExecutionConfiguration;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }
}

