/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.prefs.Preferences;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.FunctorException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Assert;
import org.pentaho.di.core.util.KeyValueSet;
import org.pentaho.di.core.util.PluginProperty;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public final class PluginPropertyHandler {
    public static void assertProperties(KeyValueSet properties) throws IllegalArgumentException {
        Assert.assertNotNull(properties, "Properties cannot be null");
    }

    public static String toXml(KeyValueSet properties) throws IllegalArgumentException {
        PluginPropertyHandler.assertProperties(properties);
        AppendXml handler = new AppendXml();
        properties.walk(handler);
        return handler.getXml();
    }

    public static void walk(KeyValueSet properties, Closure handler) throws KettleException, IllegalArgumentException {
        PluginPropertyHandler.assertProperties(properties);
        try {
            properties.walk(handler);
        }
        catch (FunctorException e) {
            throw (KettleException)e.getCause();
        }
    }

    private PluginPropertyHandler() {
    }

    public static class ReadFromPreferences
    extends AbstractHandler {
        private final Preferences node;

        public ReadFromPreferences(Preferences node) throws IllegalArgumentException {
            Assert.assertNotNull(node, "Node cannot be null");
            this.node = node;
        }

        @Override
        protected void handle(PluginProperty property) {
            property.readFromPreferences(this.node);
        }
    }

    public static class SaveToPreferences
    extends AbstractHandler {
        private final Preferences node;

        public SaveToPreferences(Preferences node) throws IllegalArgumentException {
            Assert.assertNotNull(node, "Node cannot be null");
            this.node = node;
        }

        @Override
        protected void handle(PluginProperty property) {
            property.saveToPreferences(this.node);
        }
    }

    public static class ReadFromRepository
    extends AbstractHandler {
        private final Repository repository;
        private final IMetaStore metaStore;
        private final ObjectId stepId;

        public ReadFromRepository(Repository repository, IMetaStore metaStore, ObjectId stepId) throws IllegalArgumentException {
            Assert.assertNotNull(repository, "Repository cannot be null");
            this.repository = repository;
            this.metaStore = metaStore;
            this.stepId = stepId;
        }

        @Override
        protected void handle(PluginProperty property) throws KettleException {
            property.readFromRepositoryStep(this.repository, this.metaStore, this.stepId);
        }
    }

    public static class SaveToRepository
    extends AbstractHandler {
        private final Repository repository;
        private final IMetaStore metaStore;
        private final ObjectId transformationId;
        private final ObjectId stepId;

        public SaveToRepository(Repository repository, IMetaStore metaStore, ObjectId transformationId, ObjectId stepId) throws IllegalArgumentException {
            Assert.assertNotNull(repository, "Repository cannot be null");
            this.repository = repository;
            this.metaStore = metaStore;
            this.transformationId = transformationId;
            this.stepId = stepId;
        }

        @Override
        protected void handle(PluginProperty property) throws KettleException {
            property.saveToRepositoryStep(this.repository, this.metaStore, this.transformationId, this.stepId);
        }
    }

    public static class LoadXml
    extends AbstractHandler {
        private final Node node;

        public LoadXml(Node node) throws IllegalArgumentException {
            Assert.assertNotNull(node, "Node cannot be null");
            this.node = node;
        }

        @Override
        protected void handle(PluginProperty property) {
            property.loadXml(this.node);
        }
    }

    public static class AppendXml
    extends AbstractHandler {
        private final StringBuilder builder = new StringBuilder();

        @Override
        protected void handle(PluginProperty property) {
            property.appendXml(this.builder);
        }

        public String getXml() {
            return this.builder.toString();
        }
    }

    public static class Fail
    extends AbstractHandler {
        public static final String MESSAGE = "Forced exception";
        public static final Fail INSTANCE = new Fail();

        @Override
        protected void handle(PluginProperty property) throws KettleException {
            throw new KettleException(MESSAGE);
        }
    }

    public static abstract class AbstractHandler
    implements Closure {
        public final void execute(Object property) throws IllegalArgumentException, FunctorException {
            Assert.assertNotNull(property, "Plugin property cannot be null");
            try {
                this.handle((PluginProperty)property);
            }
            catch (KettleException e) {
                throw new FunctorException("EXCEPTION: " + this, (Throwable)e);
            }
        }

        protected abstract void handle(PluginProperty var1) throws KettleException;
    }
}

