/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.version;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pentaho.di.core.exception.KettleVersionException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.version.EnvironmentVariableGetter;
import org.pentaho.di.version.ManifestGetter;

public class BuildVersion {
    public static final String REFERENCE_FILE = "/kettle-steps.xml";
    public static final String JAR_BUILD_DATE_FORMAT = "yyyy-MM-dd HH.mm.ss";
    public static final String KETTLE_BUILD_VERSION = "KETTLE_BUILD_VERSION";
    public static final String KETTLE_BUILD_REVISION = "KETTLE_BUILD_REVISION";
    public static final String KETTLE_BUILD_DATE = "KETTLE_BUILD_DATE";
    public static final String KETTLE_BUILD_USER = "KETTLE_BUILD_USER";
    protected static ManifestGetter manifestGetter = new ManifestGetter();
    protected static EnvironmentVariableGetter environmentVariableGetter = new EnvironmentVariableGetter();
    private static BuildVersion buildVersion = new BuildVersion();
    private String version;
    private String revision;
    private String buildDate;
    private String buildUser;

    public static final BuildVersion getInstance() {
        return buildVersion;
    }

    protected static void refreshInstance() {
        buildVersion = new BuildVersion();
    }

    private void loadBuildInfoFromManifest() throws Exception {
        Manifest manifest = manifestGetter.getManifest();
        this.version = manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        this.revision = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
        this.buildDate = manifest.getMainAttributes().getValue("Compile-Timestamp");
        this.buildUser = manifest.getMainAttributes().getValue("Compile-User");
        if (this.version == null) {
            throw new Exception("Error:  Version can't be NULL in manifest.");
        }
    }

    private void loadBuildInfoFromEnvironmentVariables() throws Exception {
        this.version = environmentVariableGetter.getEnvVarible(KETTLE_BUILD_VERSION);
        this.revision = environmentVariableGetter.getEnvVarible(KETTLE_BUILD_REVISION);
        this.buildDate = environmentVariableGetter.getEnvVarible(KETTLE_BUILD_DATE);
        this.buildUser = environmentVariableGetter.getEnvVarible(KETTLE_BUILD_USER);
        if (this.version == null) {
            throw new Exception("Error : Version can't be null in environment variables");
        }
    }

    private BuildVersion() {
        try {
            this.loadBuildInfoFromManifest();
        }
        catch (Throwable e) {
            try {
                this.loadBuildInfoFromEnvironmentVariables();
            }
            catch (Throwable e2) {
                this.version = "Unknown";
                this.revision = "0";
                this.buildDate = XMLHandler.date2string(new Date());
                this.buildUser = System.getProperty("user.name");
            }
        }
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public Date getBuildDateAsLocalDate() {
        SimpleDateFormat sdf = new SimpleDateFormat(JAR_BUILD_DATE_FORMAT);
        try {
            Date d = sdf.parse(this.buildDate);
            return d;
        }
        catch (ParseException e) {
            sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            try {
                Date d = sdf.parse(this.buildDate);
                return d;
            }
            catch (ParseException parseException) {
                return null;
            }
        }
    }

    public void setBuildDate(String buildDate) throws KettleVersionException {
        String tempDate = this.buildDate;
        this.buildDate = buildDate;
        Date testDate = this.getBuildDateAsLocalDate();
        if (testDate == null) {
            this.buildDate = tempDate;
            throw new KettleVersionException("Error:  Invalid date being set as build date");
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getBuildUser() {
        return this.buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }
}

