/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.metrics;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.metrics.MetricsDuration;
import org.pentaho.di.core.metrics.MetricsSnapshotInterface;
import org.pentaho.di.core.metrics.MetricsSnapshotType;

public class MetricsUtil {
    public static List<MetricsDuration> getDuration(String logChannelId, Metrics metric) {
        ArrayList<MetricsDuration> durations = new ArrayList<MetricsDuration>();
        Deque<MetricsSnapshotInterface> metrics = MetricsRegistry.getInstance().getSnapshotList(logChannelId);
        MetricsSnapshotInterface start = null;
        for (MetricsSnapshotInterface snapshot : metrics) {
            if (!snapshot.getMetric().equals(metric)) continue;
            if (snapshot.getMetric().getType() == MetricsSnapshotType.START) {
                if (start != null) {
                    durations.add(new MetricsDuration(start.getDate(), snapshot.getMetric().getDescription(), snapshot.getSubject(), logChannelId, null));
                }
                start = snapshot;
                continue;
            }
            long duration = snapshot.getDate().getTime() - start.getDate().getTime();
            durations.add(new MetricsDuration(start.getDate(), snapshot.getMetric().getDescription(), snapshot.getSubject(), logChannelId, duration));
            start = null;
        }
        HashMap<String, MetricsDuration> map = new HashMap<String, MetricsDuration>();
        for (MetricsDuration duration : durations) {
            String key = duration.getSubject() == null ? duration.getDescription() : duration.getDescription() + " / " + duration.getSubject();
            MetricsDuration agg = (MetricsDuration)map.get(key);
            if (agg == null) {
                map.put(key, duration);
                continue;
            }
            agg.setDuration(agg.getDuration() + duration.getDuration());
        }
        return new ArrayList<MetricsDuration>(map.values());
    }

    public static List<MetricsDuration> getAllDurations(String parentLogChannelId) {
        ArrayList<MetricsDuration> durations = new ArrayList<MetricsDuration>();
        List<String> logChannelIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
        for (String logChannelId : logChannelIds) {
            LoggingObjectInterface object = LoggingRegistry.getInstance().getLoggingObject(logChannelId);
            if (object == null) continue;
            durations.addAll(MetricsUtil.getDurations(logChannelId));
        }
        return durations;
    }

    public static List<MetricsDuration> getDurations(String logChannelId) {
        HashMap<String, MetricsSnapshotInterface> last = new HashMap<String, MetricsSnapshotInterface>();
        HashMap<String, MetricsDuration> map = new HashMap<String, MetricsDuration>();
        Deque<MetricsSnapshotInterface> metrics = MetricsRegistry.getInstance().getSnapshotList(logChannelId);
        for (MetricsSnapshotInterface snapshot : metrics) {
            String key = snapshot.getMetric().getDescription() + (snapshot.getSubject() == null ? "" : " - " + snapshot.getSubject());
            MetricsSnapshotInterface lastSnapshot = (MetricsSnapshotInterface)last.get(key);
            if (lastSnapshot == null) {
                lastSnapshot = snapshot;
                last.put(key, lastSnapshot);
                continue;
            }
            MetricsInterface metric = lastSnapshot.getMetric();
            if (metric.getType() != MetricsSnapshotType.START || snapshot.getMetric().getType() != MetricsSnapshotType.STOP) continue;
            long extraDuration = snapshot.getDate().getTime() - lastSnapshot.getDate().getTime();
            MetricsDuration metricsDuration = (MetricsDuration)map.get(key);
            if (metricsDuration == null) {
                metricsDuration = new MetricsDuration(lastSnapshot.getDate(), metric.getDescription(), lastSnapshot.getSubject(), logChannelId, extraDuration);
            } else {
                metricsDuration.setDuration(metricsDuration.getDuration() + extraDuration);
                metricsDuration.incrementCount();
                if (metricsDuration.getEndDate().getTime() < snapshot.getDate().getTime()) {
                    metricsDuration.setEndDate(snapshot.getDate());
                }
            }
            map.put(key, metricsDuration);
        }
        return new ArrayList<MetricsDuration>(map.values());
    }

    public static List<MetricsSnapshotInterface> getResultsList(Metrics metric) {
        ArrayList<MetricsSnapshotInterface> snapshots = new ArrayList<MetricsSnapshotInterface>();
        Map<String, Map<String, MetricsSnapshotInterface>> snapshotMaps = MetricsRegistry.getInstance().getSnapshotMaps();
        for (Map<String, MetricsSnapshotInterface> map : snapshotMaps.values()) {
            for (MetricsSnapshotInterface snapshot : map.values()) {
                if (!snapshot.getMetric().equals(metric)) continue;
                snapshots.add(snapshot);
            }
        }
        return snapshots;
    }

    public static Long getResult(Metrics metric) {
        Map<String, Map<String, MetricsSnapshotInterface>> snapshotMaps = MetricsRegistry.getInstance().getSnapshotMaps();
        for (Map<String, MetricsSnapshotInterface> map : snapshotMaps.values()) {
            for (MetricsSnapshotInterface snapshot : map.values()) {
                if (!snapshot.getMetric().equals(metric)) continue;
                return snapshot.getValue();
            }
        }
        return null;
    }
}

