/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.encryption;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;

public class CertificateGenEncryptUtil {
    public static final int KEY_SIZE = 1024;
    public static final String PUBLIC_KEY_ALGORITHM = "RSA";
    public static final String SINGLE_KEY_ALGORITHM = "AES";
    public static final String TRANSMISSION_CIPHER_PARAMS = "RSA/ECB/PKCS1Padding";
    private static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Certificate Encryption Utility", LoggingObjectType.GENERAL, null);
    private static final LogChannel log = new LogChannel(loggingObject);

    public static KeyPair generateKeyPair() {
        KeyPair pair = null;
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(PUBLIC_KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            pair = keyPairGen.generateKeyPair();
        }
        catch (Exception ex) {
            log.logError(ex.getLocalizedMessage(), ex);
        }
        return pair;
    }

    public static Key generateSingleKey() throws NoSuchAlgorithmException {
        SecretKey key = KeyGenerator.getInstance(SINGLE_KEY_ALGORITHM).generateKey();
        return key;
    }

    public static byte[] encodeKeyForTransmission(Key encodingKey, Key keyToEncode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(TRANSMISSION_CIPHER_PARAMS);
        cipher.init(3, encodingKey);
        byte[] encodedKey = cipher.wrap(keyToEncode);
        return encodedKey;
    }

    public static Key decodeTransmittedKey(byte[] sessionKey, byte[] transmittedKey, boolean privateKey) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        EncodedKeySpec keySpec = null;
        Key keyKey = null;
        if (transmittedKey == null || sessionKey == null) {
            return null;
        }
        if (!privateKey) {
            keySpec = new X509EncodedKeySpec(sessionKey);
            keyKey = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM).generatePublic(keySpec);
        } else {
            keySpec = new PKCS8EncodedKeySpec(sessionKey);
            keyKey = KeyFactory.getInstance(PUBLIC_KEY_ALGORITHM).generatePrivate(keySpec);
        }
        Cipher keyCipher = Cipher.getInstance(TRANSMISSION_CIPHER_PARAMS);
        keyCipher.init(4, keyKey);
        return keyCipher.unwrap(transmittedKey, SINGLE_KEY_ALGORITHM, 3);
    }

    public static Cipher initDecryptionCipher(Key unwrappedKey, byte[] unencryptedKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher decryptionCip = Cipher.getInstance(SINGLE_KEY_ALGORITHM);
        if (unwrappedKey != null) {
            decryptionCip.init(1, unwrappedKey);
        } else {
            SecretKeySpec sks = new SecretKeySpec(unencryptedKey, SINGLE_KEY_ALGORITHM);
            decryptionCip.init(1, sks);
        }
        return decryptionCip;
    }

    public static byte[] encryptUsingKey(byte[] data, Key key) {
        byte[] result = null;
        try {
            Cipher cipher = Cipher.getInstance(PUBLIC_KEY_ALGORITHM);
            cipher.init(1, key);
            result = cipher.doFinal(data);
        }
        catch (Exception ex) {
            log.logError(ex.getLocalizedMessage(), ex);
        }
        return result;
    }

    public static byte[] decryptUsingKey(byte[] data, Key key) {
        byte[] result = null;
        try {
            Cipher cipher = Cipher.getInstance(PUBLIC_KEY_ALGORITHM);
            cipher.init(2, key);
            result = cipher.doFinal(data);
        }
        catch (Exception ex) {
            log.logError(ex.getLocalizedMessage(), ex);
        }
        return result;
    }
}

