/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.jasperreports.compilers.JavaScriptCompiler;
import net.sf.jasperreports.compilers.JavaScriptFunctionsObject;
import net.sf.jasperreports.compilers.ReportClassShutter;
import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.ProtectionDomainFactory;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.Codegen;
import org.mozilla.javascript.tools.shell.JavaPolicySecurity;

public class JavaScriptEvaluatorScope {
    private static final Log log = LogFactory.getLog(JavaScriptEvaluatorScope.class);
    protected static final String EVALUATOR_VAR = "_jreval";
    private static Map<Context, Void> ownContexts = Collections.synchronizedMap(new WeakHashMap());
    private ReportClassShutter classShutter;
    private Context context;
    private ScriptableObject scope;
    private volatile ProtectionDomain protectionDomain;
    private Map<String, Script> compiledExpressions = new HashMap<String, Script>();

    public JavaScriptEvaluatorScope(JasperReportsContext jrContext, JREvaluator evaluator, FunctionsUtil functionsUtil) {
        this.classShutter = new ReportClassShutter(jrContext);
        this.context = this.enter(null);
        ownContexts.put(this.context, null);
        int optimizationLevel = JRPropertiesUtil.getInstance(jrContext).getIntegerProperty("net.sf.jasperreports.javascript.evaluator.optimization.level");
        if (log.isDebugEnabled()) {
            log.debug((Object)("optimization level " + optimizationLevel));
        }
        this.context.setOptimizationLevel(optimizationLevel);
        this.context.getWrapFactory().setJavaPrimitiveWrap(false);
        this.context.setSecurityController((SecurityController)new JavaPolicySecurity());
        JavaScriptFunctionsObject functionsObject = new JavaScriptFunctionsObject(this.context, functionsUtil, evaluator);
        this.scope = this.context.initStandardObjects();
        this.scope.setPrototype((Scriptable)functionsObject);
        this.scope.put(EVALUATOR_VAR, (Scriptable)this.scope, (Object)evaluator);
        Context.exit();
    }

    public void init(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) {
        String name;
        for (Map.Entry<String, JRFillParameter> entry : parametersMap.entrySet()) {
            name = entry.getKey();
            JRFillParameter param = entry.getValue();
            JSParameter jsParam = new JSParameter(param, this.scope);
            this.scope.put(JavaScriptCompiler.getParameterVar(name), (Scriptable)this.scope, (Object)jsParam);
        }
        for (Map.Entry<String, JRCloneable> entry : variablesMap.entrySet()) {
            name = entry.getKey();
            JRFillVariable var = (JRFillVariable)entry.getValue();
            JSVariable jsVar = new JSVariable(var, this.scope);
            this.scope.put(JavaScriptCompiler.getVariableVar(name), (Scriptable)this.scope, (Object)jsVar);
        }
        if (fieldsMap != null) {
            for (Map.Entry<String, JRCloneable> entry : fieldsMap.entrySet()) {
                name = entry.getKey();
                JRFillField field = (JRFillField)entry.getValue();
                JSField jsField = new JSField(field, this.scope);
                this.scope.put(JavaScriptCompiler.getFieldVar(name), (Scriptable)this.scope, (Object)jsField);
            }
        }
    }

    protected void ensureContext() {
        this.enter(this.context);
    }

    public Object evaluateExpression(Script expression) {
        Object javaValue;
        this.ensureContext();
        Object value = expression.exec(this.context, (Scriptable)this.scope);
        if (value == null || value instanceof Number) {
            javaValue = value;
        } else {
            try {
                javaValue = Context.jsToJava((Object)value, Object.class);
            }
            catch (EvaluatorException e) {
                throw new JRRuntimeException(e);
            }
        }
        return javaValue;
    }

    public Object evaluateExpression(String expression) {
        Script compiledExpression = this.getCompiledExpression(expression);
        return this.evaluateExpression(compiledExpression);
    }

    public void setScopeVariable(String name, Object value) {
        this.scope.put(name, (Scriptable)this.scope, value);
    }

    protected Script getCompiledExpression(String expression) {
        Script compiledExpression = this.compiledExpressions.get(expression);
        if (compiledExpression == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("compiling expression " + expression));
            }
            this.ensureContext();
            compiledExpression = this.context.compileString(expression, "expression", 0, (Object)this.getProtectionDomain());
            this.compiledExpressions.put(expression, compiledExpression);
        }
        return compiledExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtectionDomain getProtectionDomain() {
        ProtectionDomain domain = this.protectionDomain;
        if (domain == null) {
            JavaScriptEvaluatorScope javaScriptEvaluatorScope = this;
            synchronized (javaScriptEvaluatorScope) {
                domain = this.protectionDomain;
                if (domain == null) {
                    ProtectionDomainFactory protectionDomainFactory = JRClassLoader.getProtectionDomainFactory();
                    domain = this.protectionDomain = protectionDomainFactory.getProtectionDomain(Codegen.class.getClassLoader());
                }
            }
        }
        return domain;
    }

    protected Context enter(Context context) {
        Context newContext;
        Context.ClassShutterSetter classShutterSetter;
        Context currentContext = Context.getCurrentContext();
        if (context != null && context == currentContext) {
            return currentContext;
        }
        if (currentContext != null && ownContexts.containsKey(currentContext)) {
            Context.exit();
        }
        if ((classShutterSetter = (newContext = ContextFactory.getGlobal().enterContext(context)).getClassShutterSetter()) != null) {
            classShutterSetter.setClassShutter((ClassShutter)this.classShutter);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("entered context " + newContext + ", requested " + context));
        }
        return newContext;
    }

    public static class JSVariable
    extends JSValue {
        private final JRFillVariable variable;

        public JSVariable(JRFillVariable variable, ScriptableObject scope) {
            super(scope);
            this.variable = variable;
        }

        public Object getValue() {
            return this.toJSValue(this.variable.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.variable.getOldValue());
        }

        public Object getEstimatedValue() {
            return this.toJSValue(this.variable.getEstimatedValue());
        }
    }

    public static class JSField
    extends JSValue {
        private final JRFillField field;

        public JSField(JRFillField field, ScriptableObject scope) {
            super(scope);
            this.field = field;
        }

        public Object getValue() {
            return this.toJSValue(this.field.getValue());
        }

        public Object getOldValue() {
            return this.toJSValue(this.field.getOldValue());
        }
    }

    public static class JSParameter
    extends JSValue {
        private final JRFillParameter parameter;

        public JSParameter(JRFillParameter parameter, ScriptableObject scope) {
            super(scope);
            this.parameter = parameter;
        }

        public Object getValue() {
            return this.toJSValue(this.parameter.getValue());
        }
    }

    public static abstract class JSValue {
        private final ScriptableObject scope;

        protected JSValue(ScriptableObject scope) {
            this.scope = scope;
        }

        protected final Object toJSValue(Object value) {
            return Context.javaToJS((Object)value, (Scriptable)this.scope);
        }
    }
}

