/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import de.his.tools.StringUtil;
import de.his.tools.XMLUtil;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class XMLAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(XMLAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        Element accounts = confElement.getChild("accounts");
        if (accounts == null) {
            logger.error((Object)"Erwarte accounts-Kindelement im XMLAuth-Abschnitt der LoginConf.xml");
            return userProp;
        }
        String username = authProp.getProperty("username", "").trim();
        String password = authProp.getProperty("password", "").trim();
        if (password.equals("")) {
            return userProp;
        }
        for (Element user : XMLUtil.getChildren(accounts)) {
            if (!username.equals(user.getAttributeValue("username")) || !password.equals(user.getAttributeValue("password"))) continue;
            this.createProperties(userProp, confElement);
            return userProp;
        }
        return userProp;
    }

    private void createProperties(Properties userProp, Element confElement) {
        Properties prop = PropUtil.xmlToProperties(confElement.getChild("user-prop"));
        for (Object key : prop.keySet()) {
            userProp.put(key, StringUtil.argsubst(prop.get(key).toString(), userProp));
        }
    }
}

