/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.StringUtil;
import java.util.LinkedList;
import java.util.Properties;
import javax.mail.URLName;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.jradiusclient.RadiusClient;
import net.sourceforge.jradiusclient.RadiusPacket;
import net.sourceforge.jradiusclient.attributes.UserNameAttribute;
import net.sourceforge.jradiusclient.attributes.UserPasswordAttribute;
import net.sourceforge.jradiusclient.exception.InvalidParameterException;
import net.sourceforge.jradiusclient.exception.RadiusException;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class RadiusAuth
implements AuthenticationPlugin {
    private static final String CONFIG_ACCOUNTING_PORT = "accounting-port";
    private static final String CONFIG_AUTHENTICATION_PORT = "authentication-port";
    private static final String CONFIG_URL = "url";
    private static final String CONFIG_SERVER = "server";
    private static final String CONFIG_SHARED_SECRET = "shared-secret";
    private static Logger logger = Logger.getLogger(RadiusAuth.class);

    @Override
    public boolean init(AuthenticationManagerConfig authConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        try {
            logger.debug((Object)"Authentication: entering radiusAuth");
            String userName = authProp.getProperty("username", "").trim();
            if (userName.length() == 0) {
                logger.debug((Object)"radiusAuth uebersprungen, weil Variable username undefiniert");
                return userProp;
            }
            String host = null;
            String sharedSecret = null;
            if (confElement.getChildText(CONFIG_SERVER) == null && confElement.getChildText(CONFIG_URL) != null) {
                logger.warn((Object)"URLAuthentication ist deprecated.");
                URLName urln = new URLName(StringUtil.argsubst(confElement.getChildText(CONFIG_URL), authProp));
                host = urln.getHost();
                String query = urln.getFile();
                sharedSecret = StringUtil.replace(query, "?sharedSecret=", "");
            } else {
                host = confElement.getChildText(CONFIG_SERVER);
                sharedSecret = confElement.getChildText(CONFIG_SHARED_SECRET);
            }
            if (host == null || sharedSecret == null) {
                logger.error((Object)"server oder shared-secret nicht definiert in der Datei LoginConf.xml");
                return userProp;
            }
            int authenticationPort = StringUtil.stringToInt(confElement.getChildText(CONFIG_AUTHENTICATION_PORT), 1812);
            int accountingPort = StringUtil.stringToInt(confElement.getChildText(CONFIG_ACCOUNTING_PORT), 1813);
            RadiusClient rc = null;
            try {
                rc = new RadiusClient(host, authenticationPort, accountingPort, sharedSecret);
            }
            catch (RadiusException radex) {
                logger.warn((Object)"Unable to create Radius Client!", (Throwable)radex);
            }
            catch (InvalidParameterException ivpex) {
                logger.warn((Object)("Unable to create Radius Client due to invalid parameter! " + ivpex.getMessage()));
            }
            if (rc == null) {
                return userProp;
            }
            LinkedList<Object> attribute = new LinkedList<Object>();
            String charset = confElement.getChildText("charset");
            if (charset == null) {
                charset = "UTF-8";
            }
            attribute.add(new UserNameAttribute(userName));
            attribute.add(new UserPasswordAttribute(authProp.getProperty("password").getBytes(charset)));
            RadiusPacket returnCode = null;
            try {
                RadiusPacket packet = new RadiusPacket(1, attribute);
                returnCode = rc.authenticate(packet);
            }
            catch (InvalidParameterException ivpex) {
                logger.warn((Object)ivpex.getMessage());
                return userProp;
            }
            catch (RadiusException rex) {
                logger.warn((Object)rex.getMessage());
                return userProp;
            }
            switch (returnCode.getPacketType()) {
                case 2: {
                    logger.info((Object)"authenticated via radius");
                    userProp.put("authenticated", "y");
                    break;
                }
                case 3: {
                    logger.info((Object)"not authenticated, radius reject");
                    break;
                }
                case 11: {
                    logger.info((Object)"not authenticated, radius challenge");
                    break;
                }
                default: {
                    logger.info((Object)("not authenticated, nocon: " + host));
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        return userProp;
    }
}

