/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth.plugin;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.security.auth.plugin.TicketAction;
import de.his.tools.MDFiveHash;
import de.his.tools.PropUtil;
import de.his.tools.StringUtil;
import de.his.tools.XMLUtil;
import edu.yale.its.tp.cas.client.ServiceTicketValidator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.jdom.Namespace;

public class CASAuth
implements AuthenticationPlugin {
    private static Logger logger = Logger.getLogger(CASAuth.class);
    private final Namespace CAS_NS = Namespace.getNamespace((String)"cas", (String)"http://www.yale.edu/tp/cas");
    private static AuthenticationManagerConfig authConfig;

    @Override
    public boolean init(AuthenticationManagerConfig aAuthConfig, Element confElement) {
        logger.debug((Object)("AuthPlugin: " + this.getClass()));
        authConfig = aAuthConfig;
        return true;
    }

    @Override
    public Properties authTest(Element confElement, Properties authProp, HttpServletRequest request, Properties userProp) {
        if (request == null) {
            return userProp;
        }
        if (request.getParameter("logoutRequest") == null) {
            return this.processLoginRequest(confElement, request, userProp);
        }
        this.processLogoutRequest(request);
        return userProp;
    }

    private Properties processLoginRequest(Element confElement, HttpServletRequest request, Properties userProp) {
        ServiceTicketValidator sv = new ServiceTicketValidator();
        sv.setCasValidateUrl(confElement.getChildTextTrim("validate-url"));
        sv.setServiceTicket(request.getParameter("ticket"));
        String service = request.getRequestURL().toString() + "?" + request.getQueryString();
        int pos = service.indexOf("&ticket=");
        if (pos < 0) {
            logger.debug((Object)"&ticket= fehlt in der URL vom CAS-Authentifzierungsserver");
            return userProp;
        }
        service = service.substring(0, pos);
        logger.debug((Object)("Service: " + service));
        service = StringUtil.encodeURL(service);
        sv.setService(service);
        try {
            sv.validate();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return userProp;
        }
        this.analyseResult(sv, userProp, confElement);
        userProp.put("logout_ticket", MDFiveHash.hash(request.getParameter("ticket")));
        return userProp;
    }

    private void processLogoutRequest(HttpServletRequest request) {
        String saml = request.getParameter("logoutRequest");
        logger.debug((Object)("CAS Logout Request: SAML=" + saml));
        try {
            TicketAction action;
            Element element = XMLUtil.parseXML(saml);
            String ticket = element.getChildText("SessionIndex");
            if (ticket == null) {
                ticket = element.getChildText("SessionIndex", Namespace.getNamespace((String)"urn:oasis:names:tc:SAML:2.0:protocol"));
            }
            if (ticket == null) {
                logger.error((Object)"Cannot read SessionIndex from request");
            }
            if ((action = authConfig.getTicketAction()) != null) {
                action.invalidateTicket(MDFiveHash.hash(ticket));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Fehler beim Parsen der SAML: " + saml), (Throwable)e);
        }
    }

    private void analyseResult(ServiceTicketValidator sv, Properties userProp, Element confElement) {
        if (sv.isAuthenticationSuccesful()) {
            this.putPropertiesFromConfiguration(sv, userProp, confElement);
            this.putPropertiesFromResponse(sv.getResponse(), userProp);
        } else {
            logger.info((Object)sv.getErrorMessage());
        }
    }

    private void putPropertiesFromConfiguration(ServiceTicketValidator sv, Properties userProp, Element confElement) {
        String user = sv.getUser();
        userProp.put("username", user);
        userProp.put("authenticated", "y");
        userProp.putAll((Map<?, ?>)PropUtil.xmlToProperties(confElement.getChild("user-prop")));
        logger.debug((Object)("Erfolgreich: " + user));
    }

    void putPropertiesFromResponse(String responseString, Properties userProp) {
        try {
            Element response = XMLUtil.parseXML(responseString);
            Element success = response.getChild("authenticationSuccess", this.CAS_NS);
            if (success == null) {
                return;
            }
            Element attributes = success.getChild("attributes", this.CAS_NS);
            if (attributes == null) {
                return;
            }
            this.putPropertiesFromAttributes(attributes, userProp);
        }
        catch (RuntimeException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void putPropertiesFromAttributes(Element attributes, Properties userProp) {
        for (Element attribute : XMLUtil.getChildren(attributes)) {
            userProp.put(attribute.getChildText("name", this.CAS_NS), attribute.getChildText("value", this.CAS_NS));
        }
    }
}

