/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth;

import de.his.security.auth.AuthenticationManagerConfig;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.XMLUtil;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class PluginFactory {
    private static Logger logger = Logger.getLogger(PluginFactory.class);
    private static Hashtable<String, Class<? extends AuthenticationPlugin>> plugins = new Hashtable();

    static void initPlugins(AuthenticationManagerConfig authenticationManagerConfig, Element confElement) {
        Element global = confElement.getChild("global");
        if (global == null) {
            logger.error((Object)"Missing element global");
            return;
        }
        Element pluginsElement = global.getChild("authentication-plugins");
        if (pluginsElement == null) {
            logger.error((Object)"Missing element authentication-plugin");
            return;
        }
        for (Element plugin : XMLUtil.getChildren(pluginsElement)) {
            String key = plugin.getName();
            String className = plugin.getTextNormalize();
            try {
                Class<?> clazz = Class.forName(className);
                AuthenticationPlugin authPlugin = (AuthenticationPlugin)clazz.newInstance();
                boolean shouldUse = authPlugin.init(authenticationManagerConfig, confElement);
                if (!shouldUse) continue;
                plugins.put(key, clazz);
            }
            catch (Exception e) {
                logger.error((Object)("Fehler beim Instantiieren des AuthentificationPlugins " + className + ": " + e), (Throwable)e);
            }
        }
    }

    static AuthenticationPlugin create(String type) {
        Class<? extends AuthenticationPlugin> clazz = plugins.get(type);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }
}

