/*
 * Decompiled with CFR 0.152.
 */
package de.his.security.auth;

import de.his.security.auth.PluginFactory;
import de.his.security.auth.plugin.AuthenticationPlugin;
import de.his.tools.PropUtil;
import de.his.tools.StringUtil;
import de.his.tools.XMLUtil;
import de.his.utils.Pair;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom.Element;

public final class AuthenticationDispatcher {
    private final Logger logger = Logger.getLogger(AuthenticationDispatcher.class);
    private final Element confElement;
    private final ArrayList<Pair<Element, String>> authPath = new ArrayList();
    private Properties userProp = new Properties();

    AuthenticationDispatcher(Element confElement) {
        this.confElement = confElement;
    }

    public ArrayList<Pair<Element, String>> getAuthPath() {
        return this.authPath;
    }

    public Properties getUserProp() {
        return this.userProp;
    }

    void setUserProp(Properties userProp) {
        this.userProp = userProp;
    }

    Properties verify(Properties authPropOrg, HttpServletRequest request) {
        Properties authProp = PropUtil.encodeURL(authPropOrg);
        String myBereich = authProp.getProperty("bereich", "*");
        this.userProp.put("authPath", this.authPath);
        for (Element element : XMLUtil.getChildren(this.confElement.getChild("auth"))) {
            this.userProp = PropUtil.encodeURL(this.userProp);
            if (!this.verifyStep(element, myBereich, authProp, request)) continue;
            break;
        }
        return this.userProp;
    }

    boolean verifyStep(Element step, String myBereich, Properties authProp, HttpServletRequest request) {
        if (!this.isStepExecutable(step, myBereich)) {
            return false;
        }
        if (this.isPreAuthenticationStep(step)) {
            this.clearPreAuth();
        }
        boolean preAuthenticated = this.userProp.getProperty("authenticated") != null;
        Properties userPropForStep = this.processPlugin(step, authProp, request);
        if (userPropForStep != null) {
            if (this.isFatalError(userPropForStep)) {
                this.userProp.putAll((Map<?, ?>)userPropForStep);
                this.userProp.remove("userID");
                return true;
            }
            String roles = this.userProp.getProperty("roles");
            String newRoles = userPropForStep.getProperty("roles");
            this.userProp.putAll((Map<?, ?>)userPropForStep);
            if (step.getChild("RoleMapping") != null) {
                this.userProp.put("roles", AuthenticationDispatcher.translateRoles(roles, newRoles, step.getChild("RoleMapping")));
            }
            if (this.wasSuccesful()) {
                String pwtidc = userPropForStep.getProperty("pwtidc");
                this.authPath.add(new Pair<Element, String>(step, pwtidc));
            }
            if (this.wasSuccesfulAndLastStep(step)) {
                return true;
            }
        }
        if (!preAuthenticated && this.userProp.getProperty("authenticated") != null) {
            this.authPath.add(new Pair<Element, Object>(step, null));
        }
        return false;
    }

    public static String translateRoles(String roles, String newRoles, Element roleMapping) {
        StringBuffer strBuf = new StringBuffer();
        if (roles != null) {
            strBuf.append(roles);
        }
        if (newRoles != null) {
            String[] newRolesArray = StringUtil.stringToArray(newRoles);
            for (int i = 0; i < newRolesArray.length; ++i) {
                String role = AuthenticationDispatcher.translateRole(newRolesArray[i], roleMapping);
                if (StringUtil.containsWord(strBuf.toString(), role) >= 0) continue;
                if (strBuf.length() > 0) {
                    strBuf.append(",");
                }
                strBuf.append(role);
            }
        }
        return strBuf.toString();
    }

    public static String translateRole(String role, Element roleMapping) {
        String translatedRole = role;
        if (roleMapping != null) {
            for (Element element : XMLUtil.getChildren(roleMapping)) {
                String match = element.getName();
                if (match.startsWith("_")) {
                    match = match.substring(1);
                }
                if (!match.equals(role)) continue;
                translatedRole = element.getText();
            }
        }
        return translatedRole;
    }

    boolean isStepExecutable(Element step, String myBereich) {
        if (!XMLUtil.isActive(step)) {
            return false;
        }
        boolean roleMatch = this.checkRoleParameterMatchesRoleDefinition(myBereich, step);
        if (!roleMatch) {
            this.logger.debug((Object)"Auth-Abschnitt ignoriert, weil Vorgabe-Bereich unterschiedlich.");
            return false;
        }
        return this.checkTestCondition(step);
    }

    boolean wasSuccesful() {
        String userID = this.userProp.getProperty("userID", "");
        return !userID.trim().equals("");
    }

    boolean wasSuccesfulAndLastStep(Element element) {
        if (this.wasSuccesful()) {
            return element.getChild("break") != null;
        }
        return false;
    }

    boolean checkRoleParameterMatchesRoleDefinition(String myBereich, Element element) {
        Vector<String> bereiche = StringUtil.stringToVector(element.getAttributeValue("role"));
        bereiche.addAll(StringUtil.stringToVector(element.getAttributeValue("bereich")));
        if (bereiche.size() == 0) {
            bereiche.add("*");
        }
        return bereiche.contains(myBereich) || bereiche.contains("*");
    }

    boolean isPreAuthenticationStep(Element element) {
        if (this.userProp.containsKey("authenticated")) {
            return element.getChild("break") == null && element.getChild("continue") == null;
        }
        return false;
    }

    void clearPreAuth() {
        this.userProp.remove("authenticated");
        this.authPath.clear();
    }

    boolean isFatalError(Properties userPropForStep) {
        String fatalError = userPropForStep.getProperty("fatalError");
        return fatalError != null && fatalError.trim().length() != 0;
    }

    boolean checkTestCondition(Element element) {
        String testkey = element.getChildTextTrim("test");
        if (testkey != null && !testkey.equals("")) {
            String testval = this.userProp.getProperty(testkey);
            this.logger.debug((Object)(element.getName() + ": testval=" + testval));
            if (testval == null) {
                return false;
            }
        }
        return true;
    }

    public Properties processPlugin(Element element, Properties authProp, HttpServletRequest request) {
        Properties userPropForStep = null;
        String type = element.getAttributeValue("type");
        if (type == null) {
            this.logger.error((Object)("Im Element " + element.getName() + " fehlt das Attribute type="));
            return null;
        }
        AuthenticationPlugin authPlugin = PluginFactory.create(type);
        if (authPlugin == null) {
            this.logger.error((Object)("Unbekanntes Plugin: " + type));
            return null;
        }
        try {
            Properties prop = (Properties)this.userProp.clone();
            userPropForStep = authPlugin.authTest(element, authProp, request, prop);
        }
        catch (Exception e) {
            this.logger.error((Object)("Fehler im Plugin " + type), (Throwable)e);
        }
        return userPropForStep;
    }
}

