/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.rest;

import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeType
implements Comparable<MimeType> {
    private final String type;
    private final String subtype;
    private final float quality;

    public static MimeType parse(String spec) {
        float quality = 1.0f;
        StringTokenizer params = new StringTokenizer(spec, ";");
        String typeAndSubtype = params.nextToken();
        if (params.hasMoreTokens()) {
            while (params.hasMoreTokens()) {
                String param = params.nextToken();
                StringTokenizer paramValueTokens = new StringTokenizer(param, "=");
                String paramName = paramValueTokens.nextToken();
                if (!"q".equalsIgnoreCase(paramName.trim()) || !paramValueTokens.hasMoreTokens()) continue;
                quality = Float.parseFloat(paramValueTokens.nextToken().trim());
                break;
            }
        }
        StringTokenizer typeTokens = new StringTokenizer(typeAndSubtype, "/");
        String type = typeTokens.nextToken().trim();
        if (!typeTokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Illegal content type: " + typeAndSubtype);
        }
        String subType = typeTokens.nextToken().trim();
        if (typeTokens.hasMoreTokens()) {
            throw new IllegalArgumentException("Illegal content type: " + typeAndSubtype);
        }
        return new MimeType(type, subType, quality);
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, 1.0f);
    }

    public MimeType(String type, String subtype, float quality) {
        if (type == null) {
            type = "*";
        }
        if (subtype == null) {
            subtype = "*";
        }
        this.type = type;
        this.subtype = subtype;
        this.quality = quality;
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public float getQuality() {
        return this.quality;
    }

    @Override
    public int compareTo(MimeType other) {
        if (this.quality == other.quality) {
            int comparison;
            if (this.getType().contains("*")) {
                if (!other.getType().contains("*")) {
                    return 1;
                }
            } else if (other.getType().contains("*")) {
                return -1;
            }
            if ((comparison = this.getType().compareTo(other.getType())) == 0) {
                if (this.getSubtype().contains("*")) {
                    if (!other.getSubtype().contains("*")) {
                        return 1;
                    }
                } else if (other.getSubtype().contains("*")) {
                    return -1;
                }
                comparison = this.getSubtype().compareTo(other.getSubtype());
            }
            return comparison;
        }
        if (this.quality < other.quality) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return this.getType() + "/" + this.getSubtype();
    }

    public boolean isAcceptable(MimeType mimeType) {
        boolean typeMatches = "*".equals(this.getType()) || this.getType().equals(mimeType.getType());
        boolean subtypeMatches = "*".equals(this.getSubtype()) || this.getSubtype().equals(mimeType.getSubtype());
        return typeMatches && subtypeMatches;
    }
}

