/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.dbforms.config.Field;
import org.dbforms.taglib.DbBaseHandlerTag;
import org.dbforms.util.ParseUtil;

public class DbSearchTag
extends DbBaseHandlerTag
implements TryCatchFinally {
    private String defaultValue = null;
    private String searchAlgo = "sharp";
    private String searchMode = "and";

    public void setDefault(String value) {
        this.defaultValue = value;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setSearchAlgo(String searchAlgo) {
        this.searchAlgo = searchAlgo;
    }

    public String getSearchAlgo() {
        return this.searchAlgo;
    }

    public void setSearchMode(String searchMode) {
        this.searchMode = searchMode;
    }

    public String getSearchMode() {
        return this.searchMode;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            Field field = this.getField();
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            StringBuffer tagBuf = new StringBuffer();
            StringBuffer paramNameBuf = new StringBuffer();
            paramNameBuf.append(field.getSearchFieldName());
            String oldValue = ParseUtil.getParameter(request, paramNameBuf.toString());
            tagBuf.append("<input type=\"input\" name=\"");
            tagBuf.append(paramNameBuf.toString());
            tagBuf.append("\" ");
            tagBuf.append("value=\"");
            if (oldValue != null) {
                tagBuf.append(oldValue);
            } else if (this.defaultValue != null) {
                tagBuf.append(this.defaultValue);
            }
            tagBuf.append("\"");
            tagBuf.append(this.prepareStyles());
            tagBuf.append(this.prepareEventHandlers());
            tagBuf.append("/>\n");
            this.pageContext.getOut().write(this.renderPatternHtmlInputField());
            this.pageContext.getOut().write(this.RenderHiddenFields(field));
            this.pageContext.getOut().write(tagBuf.toString());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
        return 6;
    }

    protected String getFormFieldName() {
        return this.getField().getSearchFieldName();
    }

    public void doFinally() {
        this.searchAlgo = "sharp";
        this.searchMode = "and";
        this.defaultValue = null;
        super.doFinally();
    }

    protected String RenderHiddenFields(Field f) {
        StringBuffer tagBuf = new StringBuffer();
        StringBuffer paramNameBufA = new StringBuffer();
        paramNameBufA.append(f.getSearchAlgoName());
        tagBuf.append("<input type=\"hidden\" name=\"");
        tagBuf.append(paramNameBufA.toString());
        tagBuf.append("\" value=\"");
        tagBuf.append(this.getSearchAlgo());
        tagBuf.append("\"/>\n");
        StringBuffer paramNameBufB = new StringBuffer();
        paramNameBufB.append(f.getSearchModeName());
        tagBuf.append("<input type=\"hidden\" name=\"");
        tagBuf.append(paramNameBufB.toString());
        tagBuf.append("\" value=\"");
        tagBuf.append(this.getSearchMode());
        tagBuf.append("\"/>\n");
        return tagBuf.toString();
    }
}

