/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import java.io.IOException;
import java.text.Format;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.Field;
import org.dbforms.config.ResultSetVector;
import org.dbforms.event.WebEvent;
import org.dbforms.taglib.DbCheckboxTag;
import org.dbforms.taglib.DbFormTag;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.util.ICustomFormat;
import org.dbforms.util.IEscaper;
import org.dbforms.util.MessageResources;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.ParseUtil;
import org.dbforms.util.ReflectionUtil;
import org.dbforms.util.Util;

public abstract class DbBaseHandlerTag
extends TagSupportWithScriptHandler {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$taglib$DbBaseHandlerTag == null ? (class$org$dbforms$taglib$DbBaseHandlerTag = DbBaseHandlerTag.class$("org.dbforms.taglib.DbBaseHandlerTag")) : class$org$dbforms$taglib$DbBaseHandlerTag).getName());
    private DbFormTag parentForm;
    private IEscaper escaper = null;
    private Field field;
    private Format formatter;
    private String customFormatter = null;
    private String defaultValue;
    private String escaperClass = null;
    private String fieldName;
    private String maxlength = null;
    private String nullFieldValue;
    private String overrideFormFieldName;
    private String pattern;
    private String readOnly = "false";
    private String readOnlyStyleClass = null;
    static /* synthetic */ Class class$org$dbforms$taglib$DbBaseHandlerTag;
    static /* synthetic */ Class class$org$dbforms$taglib$DbFormTag;

    public void setCustomFormatter(String string) {
        this.customFormatter = string;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public IEscaper getEscaper() {
        if (this.escaper == null) {
            String s = this.getEscaperClass();
            if (!Util.isNull(s)) {
                try {
                    this.escaper = (IEscaper)ReflectionUtil.newInstance(s);
                }
                catch (Exception e) {
                    logCat.error((Object)("cannot create the new escaper [" + s + "]"), (Throwable)e);
                }
            }
            if (this.escaper == null && this.getField() != null) {
                this.escaper = this.getField().getEscaper();
            }
            if (this.escaper == null) {
                this.escaper = this.getConfig().getEscaper();
            }
        }
        return this.escaper;
    }

    public void setEscaperClass(String string) {
        this.escaperClass = string;
    }

    public String getEscaperClass() {
        return this.escaperClass;
    }

    public Field getField() {
        return this.field;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
        if (this.getParentForm().getTable() != null) {
            this.setField(this.getParentForm().getTable().getFieldByName(fieldName));
        } else {
            this.setField(null);
        }
        if (this.getParentForm().isSubForm() && this.field != null) {
            this.getParentForm().strikeOut(this.field);
        }
    }

    public void setFormatter(Format formatter) {
        this.formatter = formatter;
    }

    public Format getFormatter() {
        Format res = this.formatter;
        if (res == null && this.getField() != null) {
            res = this.getField().getFormat(this.pattern, this.getLocale());
        }
        return res;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public String getMaxlength() {
        return this.maxlength;
    }

    public String getName() {
        return this.getField() != null ? this.getField().getName() : this.fieldName;
    }

    public void setNullFieldValue(String nullFieldValue) {
        this.nullFieldValue = nullFieldValue;
    }

    public void setOverrideFormFieldName(String string) {
        this.overrideFormFieldName = string;
    }

    public void setParent(Tag parent) {
        super.setParent(parent);
        this.parentForm = (DbFormTag)DbBaseHandlerTag.findAncestorWithClass((Tag)this, (Class)(class$org$dbforms$taglib$DbFormTag == null ? (class$org$dbforms$taglib$DbFormTag = DbBaseHandlerTag.class$("org.dbforms.taglib.DbFormTag")) : class$org$dbforms$taglib$DbFormTag));
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPattern() {
        Format f = this.getFormatter();
        if (f == null) {
            return null;
        }
        return Util.getPattern(f);
    }

    public void setReadOnly(String readOnly) {
        this.readOnly = readOnly;
    }

    public void setReadOnlyStyleClass(String readOnlyStyleClass) {
        this.readOnlyStyleClass = readOnlyStyleClass;
    }

    public String getReadOnlyStyleClass() {
        return this.readOnlyStyleClass;
    }

    public String getStyleClass() {
        boolean readonly;
        boolean bl = readonly = this.hasReadOnlySet() || this.getParentForm().hasReadOnlySet();
        if (readonly && !Util.isNull(this.getReadOnlyStyleClass())) {
            return this.getReadOnlyStyleClass();
        }
        return super.getStyleClass();
    }

    protected String customFormat(String s) {
        Object obj;
        HttpSession session;
        HashMap hm;
        if (!Util.isNull(this.customFormatter) && (hm = (HashMap)(session = this.pageContext.getSession()).getAttribute("dbforms.org.tag.CustomFormatterTag")) != null && (obj = hm.get(this.customFormatter)) instanceof ICustomFormat) {
            ICustomFormat cf = (ICustomFormat)obj;
            Locale locale = MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest());
            cf.setLocale(locale);
            s = cf.sprintf(s);
        }
        return s;
    }

    public void doFinally() {
        this.formatter = null;
        this.field = null;
        this.defaultValue = null;
        this.pattern = null;
        this.nullFieldValue = null;
        this.maxlength = null;
        this.readOnlyStyleClass = null;
        this.readOnly = "false";
        this.escaperClass = null;
        this.escaper = null;
        this.customFormatter = null;
        this.overrideFormFieldName = null;
        super.doFinally();
    }

    public boolean hasReadOnlySet() {
        return Util.getTrue(this.readOnly);
    }

    protected String getCustomFormatter() {
        return this.customFormatter;
    }

    protected void setField(Field field) {
        this.field = field;
    }

    protected Object getFieldObject() {
        Object fieldValueObj = null;
        ResultSetVector res = this.getParentForm().getResultSetVector();
        fieldValueObj = res != null && this.getField() != null ? res.getFieldAsObject(this.getField().getName()) : ((fieldValueObj = ParseUtil.getParameter((HttpServletRequest)this.pageContext.getRequest(), this.getFormFieldName())) == null ? this.getDefaultValue() : (this.getEscaper() == null ? fieldValueObj : this.getEscaper().unescapeHTML((String)fieldValueObj)));
        return fieldValueObj;
    }

    protected String getFieldValue() {
        String[] s;
        ResultSetVector rsv = this.getParentForm().getResultSetVector();
        String res = null;
        if (this.getField() != null && rsv != null && (s = rsv.getCurrentRow()) != null) {
            res = rsv.getCurrentRow()[this.getField().getId()];
        }
        return res;
    }

    protected String getFormFieldDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return this.typicalDefaultValue();
    }

    protected String getFormFieldName() {
        if (this.hasOverrideFormFieldNameSet()) {
            return this.getOverrideFormFieldName();
        }
        StringBuffer buf = new StringBuffer();
        if (this.getParentForm().getTable() != null && this.getField() != null) {
            String keyIndex = this.getParentForm().isFooterReached() ? "ins" + this.getParentForm().getPositionPathCore() : this.getParentForm().getPositionPath();
            buf.append("f_");
            buf.append(this.getParentForm().getTable().getId());
            buf.append("_");
            buf.append(keyIndex);
            buf.append("_");
            buf.append(this.getField().getId());
        } else {
            buf.append(this.fieldName);
        }
        return buf.toString();
    }

    protected String getFormFieldValue() {
        String copyValue;
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Vector errors = (Vector)request.getAttribute("errors");
        WebEvent we = this.getParentForm().getWebEvent();
        if (!this.getParentForm().isFooterReached()) {
            String oldValue;
            if ((this.getParentForm().hasRedisplayFieldsOnErrorSet() && errors != null && errors.size() > 0 || we != null && "navReload".equals(we.getType())) && (oldValue = ParseUtil.getParameter(request, this.getFormFieldName())) != null) {
                return oldValue;
            }
            return this.getFormattedFieldValue();
        }
        if (we != null && "navCopy".equals(we.getType()) && (copyValue = ParseUtil.getParameter(request, this.getFormFieldNameForCopyEvent())) != null) {
            return copyValue;
        }
        if (we != null && "navReload".equals(we.getType()) || errors != null && errors.size() > 0) {
            String oldValue = ParseUtil.getParameter(request, this.getFormFieldName());
            if (oldValue != null) {
                return oldValue;
            }
            if (this instanceof DbCheckboxTag) {
                return this.typicalDefaultValue() + "_";
            }
        }
        return this.getFormFieldDefaultValue();
    }

    protected String getFormattedFieldValue() {
        String res;
        Object fieldValueObj = this.getFieldObject();
        if (fieldValueObj == null) {
            res = this.getNullFieldValue();
        } else if (fieldValueObj.getClass().isArray() && "byte".equals(fieldValueObj.getClass().getComponentType().toString())) {
            res = new String((byte[])fieldValueObj);
        } else if (this.getField() != null) {
            switch (this.getField().getType()) {
                case 2: 
                case 4: 
                case 6: 
                case 8: 
                case 91: 
                case 92: 
                case 93: {
                    try {
                        res = this.getFormatter().format(fieldValueObj);
                    }
                    catch (Exception e) {
                        logCat.error((Object)("field type: " + this.getField().getType() + "\n" + "object type: " + fieldValueObj.getClass().getName() + "\n" + "pattern: " + this.getPattern() + "\n" + e.getMessage()));
                        res = fieldValueObj.toString();
                    }
                    break;
                }
                default: {
                    res = fieldValueObj.toString();
                    break;
                }
            }
        } else {
            res = fieldValueObj.toString();
        }
        res = this.customFormat(res);
        return res;
    }

    protected Locale getLocale() {
        return this.getParentForm().getLocale();
    }

    protected String getOverrideFormFieldName() {
        return this.overrideFormFieldName;
    }

    protected DbFormTag getParentForm() {
        return this.parentForm;
    }

    protected String escapeHTML(String html) {
        return this.getEscaper() == null ? html : this.getEscaper().escapeHTML(html);
    }

    protected boolean hasOverrideFormFieldNameSet() {
        return this.overrideFormFieldName != null;
    }

    protected String renderOldValueHtmlInputField() {
        StringBuffer tagBuf = new StringBuffer();
        tagBuf.append("<input type=\"hidden\" name=\"");
        tagBuf.append("o" + this.getFormFieldName());
        tagBuf.append("\" value=\"");
        if (!this.getParentForm().isFooterReached()) {
            tagBuf.append(this.escapeHTML(this.getFormattedFieldValue()));
        } else {
            tagBuf.append(this.escapeHTML(this.getFormFieldDefaultValue()));
        }
        tagBuf.append("\" />");
        return tagBuf.toString();
    }

    protected String renderPatternHtmlInputField() {
        StringBuffer tagBuf = new StringBuffer();
        String ppattern = this.getPattern();
        if (!Util.isNull(ppattern)) {
            tagBuf.append("<input type=\"hidden\" name=\"");
            tagBuf.append("p" + this.getFormFieldName());
            tagBuf.append("\" value=\"");
            tagBuf.append(ppattern);
            tagBuf.append("\" />");
        }
        return tagBuf.toString();
    }

    protected String typicalDefaultValue() {
        String res = "";
        if (this.getField() != null) {
            switch (this.field.getType()) {
                case 2: 
                case 4: 
                case 6: 
                case 8: {
                    try {
                        res = this.getFormatter().format(new Double(0.0));
                        break;
                    }
                    catch (Exception e) {
                        res = "0";
                    }
                }
            }
        }
        return res;
    }

    protected void writeOutSpecialValues() throws JspException {
        try {
            this.pageContext.getOut().write(this.renderOldValueHtmlInputField());
        }
        catch (IOException ioe) {
            throw new JspException("IO Error: " + ioe.getMessage());
        }
    }

    private String getFormFieldNameForCopyEvent() {
        boolean footerReached = this.getParentForm().isFooterReached();
        this.getParentForm().setFooterReached(false);
        String name = this.getFormFieldName();
        this.getParentForm().setFooterReached(footerReached);
        return name;
    }

    private String getNullFieldValue() {
        String res = this.nullFieldValue;
        if (res == null) {
            res = MessageResourcesInternal.getMessage("dbforms.nodata", this.getLocale());
        }
        if (this.getParentForm() != null && this.getParentForm().hasCaptionResourceSet()) {
            res = MessageResources.getMessage(res, this.getLocale(), res);
        }
        if (res == null) {
            res = "";
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

