/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.Field;
import org.dbforms.config.FieldValues;
import org.dbforms.event.ValidationEvent;
import org.dbforms.event.datalist.dao.DataSourceFactory;
import org.dbforms.event.datalist.dao.DataSourceSessionList;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.StringUtil;

public class InsertEvent
extends ValidationEvent {
    public InsertEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public InsertEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    public FieldValues getFieldValues() {
        return this.getFieldValues(true);
    }

    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(1)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.insert.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        FieldValues fieldValues = this.getFieldValues();
        if (fieldValues.size() == 0) {
            throw new SQLException("no parameters");
        }
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        int operation = this.getTable().processInterceptors(0, interceptorData);
        if (operation == 0 && fieldValues.size() > 0) {
            if (!this.checkSufficentValues(fieldValues)) {
                throw new SQLException("unsufficent parameters");
            }
            DataSourceSessionList ds = DataSourceSessionList.getInstance(this.getRequest());
            DataSourceFactory qry = ds.get(this.getTable(), this.getRequest());
            boolean own = false;
            if (qry == null) {
                qry = new DataSourceFactory((String)interceptorData.getAttribute("connectionName"), interceptorData.getConnection(), this.getTable());
                own = true;
            }
            qry.doInsert(interceptorData, fieldValues);
            if (own) {
                qry.close();
            } else {
                ds.remove(this.getTable(), this.getRequest());
            }
            String firstPosition = this.getTable().getPositionString(fieldValues);
            this.getRequest().setAttribute("firstpos_" + this.getTable().getId(), (Object)firstPosition);
            this.getTable().processInterceptors(1, interceptorData);
        }
    }

    private boolean checkSufficentValues(FieldValues fieldValues) throws SQLException {
        Vector fields = this.getTable().getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.elementAt(i);
            if (!field.hasAutoIncSet() && field.hasIsKeySet()) {
                if (fieldValues.get(field.getName()) != null) continue;
                throw new SQLException("Field " + field.getName() + " is missing");
            }
            if (!field.hasAutoIncSet() || fieldValues.get(field.getName()) == null) continue;
            throw new SQLException("Field " + field.getName() + " should be calculated by RDBMS, remove it from the form");
        }
        return true;
    }
}

