/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.event.datalist;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbEventInterceptorData;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.FieldValues;
import org.dbforms.event.DatabaseEvent;
import org.dbforms.event.datalist.dao.DataSourceFactory;
import org.dbforms.event.datalist.dao.DataSourceSessionList;
import org.dbforms.util.MessageResourcesInternal;
import org.dbforms.util.StringUtil;
import org.dbforms.util.Util;

public class DeleteEvent
extends DatabaseEvent {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$event$datalist$DeleteEvent == null ? (class$org$dbforms$event$datalist$DeleteEvent = DeleteEvent.class$("org.dbforms.event.datalist.DeleteEvent")) : class$org$dbforms$event$datalist$DeleteEvent).getName());
    static /* synthetic */ Class class$org$dbforms$event$datalist$DeleteEvent;

    public DeleteEvent(Integer tableId, String keyId, HttpServletRequest request, DbFormsConfig config) {
        super(tableId, keyId, request, config);
    }

    public DeleteEvent(String action, HttpServletRequest request, DbFormsConfig config) {
        super(StringUtil.getEmbeddedStringAsInteger(action, 2, '_'), StringUtil.getEmbeddedString(action, 3, '_'), request, config);
    }

    public FieldValues getFieldValues() {
        return this.getFieldValues(true);
    }

    public void processEvent(Connection con) throws SQLException {
        if (!this.hasUserPrivileg(3)) {
            String s = MessageResourcesInternal.getMessage("dbforms.events.delete.nogrant", this.getRequest().getLocale(), new String[]{this.getTable().getName()});
            throw new SQLException(s);
        }
        String keyValuesStr = this.getKeyValues();
        if (Util.isNull(keyValuesStr)) {
            logCat.error((Object)"::processEvent - At least one key is required per table, check your dbforms-config.xml");
            return;
        }
        FieldValues fieldValues = this.getFieldValues();
        DbEventInterceptorData interceptorData = new DbEventInterceptorData(this.getRequest(), this.getConfig(), con, this.getTable());
        interceptorData.setAttribute("fieldValues", fieldValues);
        interceptorData.setAttribute("keyValues", keyValuesStr);
        int operation = this.getTable().processInterceptors(4, interceptorData);
        if (operation == 0) {
            DataSourceSessionList ds = DataSourceSessionList.getInstance(this.getRequest());
            DataSourceFactory qry = ds.get(this.getTable(), this.getRequest());
            boolean own = false;
            if (qry == null) {
                qry = new DataSourceFactory((String)interceptorData.getAttribute("connectionName"), interceptorData.getConnection(), this.getTable());
                own = true;
            }
            qry.doDelete(interceptorData, keyValuesStr);
            if (own) {
                qry.close();
            } else {
                ds.remove(this.getTable(), this.getRequest());
            }
            this.getTable().processInterceptors(5, interceptorData);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

