/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.EventInfo;
import org.dbforms.config.Table;

public class TableEvents
implements Serializable {
    private static Log logCat = LogFactory.getLog((String)(class$org$dbforms$config$TableEvents == null ? (class$org$dbforms$config$TableEvents = TableEvents.class$("org.dbforms.config.TableEvents")) : class$org$dbforms$config$TableEvents).getName());
    private HashMap eventMap = new HashMap();
    private Table table = null;
    private boolean doLog = false;
    static /* synthetic */ Class class$org$dbforms$config$TableEvents;

    public TableEvents() {
        try {
            this.addEventInfo("delete");
            this.addEventInfo("insert");
            this.addEventInfo("update");
            this.addEventInfo("navFirst");
            this.addEventInfo("navGoto");
            this.addEventInfo("navLast");
            this.addEventInfo("navNew");
            this.addEventInfo("navCopy");
            this.addEventInfo("navNext");
            this.addEventInfo("navPrev");
            this.addEventInfo("navReload");
        }
        catch (Exception e) {
            logCat.error((Object)"::Table - cannot link a TableEvents object to this table", (Throwable)e);
        }
        this.doLog = true;
    }

    public String getEventId(String eventType) {
        String id = null;
        EventInfo einfo = this.getEventInfo(eventType);
        if (einfo != null) {
            id = einfo.getId();
        }
        return id;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void addEventInfo(EventInfo einfo) {
        String eventType = einfo.getType();
        if (this.eventMap.containsKey(eventType)) {
            this.eventMap.remove(eventType);
        }
        this.eventMap.put(eventType, einfo);
        if (this.doLog) {
            logCat.info((Object)("::addEventInfo - set a new eventInfo with type, id [" + eventType + ", " + einfo.getId() + "]"));
        }
    }

    private EventInfo getEventInfo(String eventType) {
        EventInfo einfo = null;
        if (this.eventMap.containsKey(eventType)) {
            einfo = (EventInfo)this.eventMap.get(eventType);
        }
        return einfo;
    }

    private void addEventInfo(String eventType) throws Exception {
        EventInfo einfo = new EventInfo();
        einfo.setType(eventType);
        einfo.setId(eventType);
        this.addEventInfo(einfo);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

