/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.connect.survey.Survey;
import de.destatis.core.map.editor.util.Converter;
import de.destatis.core.map.editor.util.SwingUtil;
import de.destatis.core.map.editor.util.ui.TableSorter;
import de.destatis.core.map.editor.wizard.AbstractStep;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SelectSurveyStep
extends AbstractStep {
    private JTable surveyTable;
    private List surveyList = null;

    public SelectSurveyStep() {
        super(new BorderLayout());
        TableSorter tableSorter = new TableSorter(new SurveyTableModel());
        this.surveyTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.surveyTable.getTableHeader());
        tableSorter.setColumnComparator(String.class, Collator.getInstance(Locale.GERMAN));
        this.surveyTable.getTableHeader().setReorderingAllowed(false);
        this.surveyTable.setAutoResizeMode(0);
        this.surveyTable.setGridColor(SystemColor.control);
        this.surveyTable.setRowHeight(18);
        this.surveyTable.getSelectionModel().setSelectionMode(0);
        this.surveyTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectSurveyStep.this.fireStateChanged();
            }
        });
        SwingUtil.removeUunnecessaryActionsFromTable(this.surveyTable);
        TableColumn column = this.surveyTable.getTableHeader().getColumnModel().getColumn(0);
        column.setPreferredWidth(83);
        column = this.surveyTable.getTableHeader().getColumnModel().getColumn(1);
        column.setPreferredWidth(370);
        column = this.surveyTable.getTableHeader().getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        column = this.surveyTable.getTableHeader().getColumnModel().getColumn(3);
        column.setPreferredWidth(100);
        JScrollPane scrollPane = new JScrollPane(this.surveyTable);
        scrollPane.getViewport().setBackground(this.surveyTable.getBackground());
        this.add((Component)scrollPane, "Center");
    }

    public void setSurveyList(List surveyList) {
        this.surveyList = surveyList;
        ((AbstractTableModel)((TableSorter)this.surveyTable.getModel()).getTableModel()).fireTableDataChanged();
    }

    public Survey getSelectedSurvey() {
        int selectedRow = this.surveyTable.getSelectedRow();
        int modelIndex = ((TableSorter)this.surveyTable.getModel()).modelIndex(selectedRow);
        return (Survey)this.surveyList.get(modelIndex);
    }

    @Override
    public String getTitle() {
        return "Erhebung ausw\u00e4hlen";
    }

    @Override
    public String getInfo() {
        return "W\u00e4hlen Sie eine Erhebung aus, f\u00fcr die das neue Mapping erstellt werden soll.";
    }

    @Override
    public boolean isComplete() {
        return this.surveyTable.getSelectedRow() >= 0;
    }

    private class SurveyTableModel
    extends AbstractTableModel {
        private SurveyTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ErhebungsID";
                }
                case 1: {
                    return "Beschreibung";
                }
                case 2: {
                    return "Land";
                }
                case 3: {
                    return "G\u00fcltig ab";
                }
            }
            throw new IllegalArgumentException("column=" + column);
        }

        @Override
        public int getRowCount() {
            return SelectSurveyStep.this.surveyList != null ? SelectSurveyStep.this.surveyList.size() : 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Survey survey = this.getSurvey(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return survey.getErhebungsId().getErhebungsId();
                }
                case 1: {
                    return survey.getDescription();
                }
                case 2: {
                    return Converter.convertLkzToDescr(survey.getLkz());
                }
                case 3: {
                    return Converter.convertTimeIDToDescr(survey.getErhebungsId().getTimeId());
                }
            }
            throw new IllegalArgumentException("columnIndex=" + columnIndex);
        }

        public Survey getSurvey(int row) {
            return (Survey)SelectSurveyStep.this.surveyList.get(row);
        }
    }
}

