/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.map.editor.wizard.Step;
import de.destatis.core.map.editor.wizard.Wizard;
import java.awt.Dialog;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractWizard
implements Wizard {
    private Step currentStep = null;
    private ChangeListener listener = null;
    private boolean canceled = false;

    protected void setCurrentStep(Step currentStep) {
        this.currentStep = currentStep;
    }

    @Override
    public Step getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public boolean back() {
        boolean performed;
        if (this.getPreviousStep() != null) {
            if (this.onBack()) {
                this.setCurrentStep(this.getPreviousStep());
                performed = true;
            } else {
                performed = false;
            }
        } else {
            performed = false;
        }
        return performed;
    }

    protected boolean onBack() {
        return true;
    }

    @Override
    public boolean next() {
        boolean performed;
        if (this.getNextStep() != null) {
            this.getCurrentStep().commit();
            if (this.onNext()) {
                this.setCurrentStep(this.getNextStep());
                performed = true;
            } else {
                performed = false;
            }
        } else {
            performed = false;
        }
        return performed;
    }

    protected boolean onNext() {
        return true;
    }

    @Override
    public boolean finish() {
        return true;
    }

    @Override
    public boolean cancel() {
        this.canceled = true;
        return true;
    }

    @Override
    public void setChangeListener(ChangeListener listener) {
        this.listener = listener;
        Step[] steps = this.getAllSteps();
        if (steps != null) {
            for (int i = 0; i < steps.length; ++i) {
                steps[i].setChangeListener(listener);
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    protected void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    protected abstract Step[] getAllSteps();

    protected Dialog getDialog() {
        return (Dialog)SwingUtilities.getWindowAncestor(this.getCurrentStep().getComponent());
    }

    @Override
    public boolean isComplete() {
        boolean complete = false;
        Step currentStep = this.getCurrentStep();
        if (currentStep != null && currentStep.isComplete() && this.getNextStep() == null) {
            complete = true;
        }
        return complete;
    }
}

