/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.task;

import de.destatis.core.map.editor.task.AbortException;
import de.destatis.core.map.editor.task.ProgressMonitor;

public abstract class Task {
    private boolean aborted = false;
    private Throwable throwable = null;

    public boolean isAborted() {
        return this.aborted;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void execute(final ProgressMonitor monitor, boolean background) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Task.this.execute(monitor);
                    monitor.finished();
                }
                catch (AbortException e) {
                    Task.this.aborted = true;
                    monitor.failed();
                }
                catch (Throwable e) {
                    Task.this.throwable = e;
                    monitor.failed();
                }
            }
        };
        if (background) {
            new Thread(runnable).start();
            monitor.started();
        } else {
            monitor.started();
            runnable.run();
        }
    }

    protected void abortIfCanceled(ProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new AbortException();
        }
    }

    protected abstract void execute(ProgressMonitor var1) throws Exception;
}

