/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.util;

import de.destatis.core.connect.util.ClientConfig;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class ClientLogger {
    private static final String CONSOLE_LOG = "CONSOLE";
    private static boolean initialized = false;
    private Logger logger = null;

    public static final ClientLogger getLogger(Class type) {
        if (!initialized) {
            ClientLogger.initializeLogger();
        }
        return new ClientLogger(Logger.getLogger((Class)type));
    }

    public static final ClientLogger getLogger(String name) {
        if (!initialized) {
            ClientLogger.initializeLogger();
        }
        return new ClientLogger(Logger.getLogger((String)name));
    }

    public ClientLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(Object message) {
        this.logger.error(message);
    }

    public void error(Object message, Throwable exc) {
        this.logger.error(message, exc);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)Level.INFO);
    }

    public void info(Object message) {
        this.logger.info(message);
    }

    public void info(Object message, Throwable exc) {
        this.logger.info(message, exc);
    }

    public boolean isTraceEnabled() {
        return this.isDebugEnabled();
    }

    public void trace(Object message) {
        this.debug("TEST: " + message);
    }

    public void trace(Object message, Throwable exc) {
        this.debug("TEST: " + message, exc);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Object message) {
        this.logger.debug(message);
    }

    public void debug(Object message, Throwable exc) {
        this.logger.debug(message, exc);
    }

    private static synchronized void initializeLogger() {
        if (!initialized) {
            String logFile = ClientConfig.getLogFile();
            if (logFile != null) {
                Properties logProps = new Properties();
                logProps.setProperty("log4j.rootLogger", ", CORE");
                if (CONSOLE_LOG.equals(logFile)) {
                    logProps.setProperty("log4j.appender.CORE", "org.apache.log4j.ConsoleAppender");
                } else {
                    logProps.setProperty("log4j.appender.CORE", "org.apache.log4j.RollingFileAppender");
                    logProps.setProperty("log4j.appender.CORE.File", logFile);
                    logProps.setProperty("log4j.appender.CORE.MaxFileSize", "1MB");
                    logProps.setProperty("log4j.appender.CORE.MaxBackupIndex", "0");
                }
                logProps.setProperty("log4j.appender.CORE.layout", "org.apache.log4j.PatternLayout");
                String logLevel = "OFF";
                switch (ClientConfig.getLogLevel()) {
                    case 0: {
                        logLevel = "WARN";
                        break;
                    }
                    case 1: {
                        logLevel = "INFO";
                        break;
                    }
                    case 2: {
                        logLevel = "DEBUG";
                    }
                }
                if ("DEBUG".equals(logLevel)) {
                    logProps.setProperty("log4j.appender.CORE.layout.ConversionPattern", "%d{yyyyMMdd:HHmmss} %c{1} - %m%n");
                } else {
                    logProps.setProperty("log4j.appender.CORE.layout.ConversionPattern", "%d{yyyyMMdd:HHmmss} - %m%n");
                }
                logProps.setProperty("log4j.logger.de.destatis.core", logLevel);
                logProps.setProperty("log4j.logger.org.apache.http", "DEBUG".equals(logLevel) ? logLevel : "OFF");
                logProps.setProperty("log4j.logger.org.apache.http.wire", logLevel);
                logProps.setProperty("log4j.logger.org.apache.http.impl.client.DefaultHttpClient", logLevel);
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Log4JLogger");
                PropertyConfigurator.configure((Properties)logProps);
            }
            initialized = true;
        }
    }
}

