/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.util.Contract;
import java.util.HashMap;

public class TransferProtocol {
    private static HashMap values = new HashMap();
    private String protocol = null;
    public static final TransferProtocol HTTPS = new TransferProtocol("https");
    public static final TransferProtocol OSCI = new TransferProtocol("osci");

    public static TransferProtocol getInstance(String protocol) {
        Contract.verify(values.containsKey(protocol.toLowerCase()), "Unbekanntes Protokoll angegeben!");
        return (TransferProtocol)values.get(protocol.toLowerCase());
    }

    public String toString() {
        return this.protocol;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof TransferProtocol) {
            TransferProtocol other = (TransferProtocol)obj;
            result = this.protocol.equals(other.protocol);
        }
        return result;
    }

    private TransferProtocol(String protocol) {
        this.protocol = protocol.toLowerCase();
        values.put(this.protocol, this);
    }
}

