/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.Contract;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AntInstrUtils;
import com.atlassian.clover.ant.AntLogger;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.ant.tasks.TestSourceSet;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.instr.tests.FileMappedTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.ClassPathUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.JavaEnvUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverCompilerAdapter
implements CompilerAdapter {
    private Logger log;
    private String compilerDelegate;
    private Javac javac;
    private CompilerAdapter underlyingCompiler;
    private Project project;
    private CloverException error;
    private String javacName;
    private File tmpDir;
    private boolean preserveInstr;
    private CompilerVersionFiddler compilerVersionFiddler = new CompilerVersionFiddler();

    private void cloverLogging() {
        this.javacName = this.javac.getTaskName();
        this.javac.setTaskName("clover");
    }

    private void javacLogging() {
        this.javac.setTaskName(this.javacName);
    }

    public void setJavac(Javac aJavac) {
        Contract.pre(aJavac != null);
        this.javac = aJavac;
        this.project = this.javac.getProject();
        Logger.setInstance(new AntLogger(this.project, (Task)this.javac));
        this.log = Logger.getInstance();
        this.cloverLogging();
        CloverStartup.loadLicense(this.log);
        if (this.javac.getDestdir() == null) {
            this.error = new CloverException("When using Clover you need to set the destdir on <javac>");
            return;
        }
        AntInstrumentationConfig instrConfig = AntInstrumentationConfig.getFrom(this.project);
        if (instrConfig == null) {
            instrConfig = new AntInstrumentationConfig(this.project);
        }
        this.compilerDelegate = instrConfig.getCompilerDelegate();
        this.preserveInstr = instrConfig.isPreserve();
        if (this.javac.isForkedJavac()) {
            this.log.info("Fork is set to true and will be respected (ignore any warnings from Ant).");
            if (this.compilerDelegate != null && !"extJavac".equals(this.compilerDelegate)) {
                this.log.warn("Ignoring clover.compiler setting because fork is true. Using 'extJavac' compiler.");
            }
            this.compilerDelegate = "extJavac";
        }
        if (this.compilerDelegate != null && this.compilerDelegate.equals(this.getClass().getName())) {
            this.error = new CloverException("You cannot set clover.compiler to be the Clover Compiler Adapter. Check the value you are passing to clover.compiler");
            return;
        }
        if (this.compilerDelegate == null) {
            this.compilerDelegate = CloverCompilerAdapter.getDefaultAntCompiler();
        }
        this.log.debug("using underlying compiler '" + this.compilerDelegate + "'");
        this.underlyingCompiler = CompilerAdapterFactory.getCompiler((String)this.compilerDelegate, (Task)this.javac);
        this.log.debug("underlying compiler instance is " + this.underlyingCompiler.getClass().getName());
        if (instrConfig.isEnabled()) {
            String encoding;
            String src = this.javac.getSource();
            if (src != null) {
                instrConfig.setSourceLevel(src);
            }
            if ((encoding = this.javac.getEncoding()) != null) {
                instrConfig.setEncoding(this.javac.getEncoding());
            }
            PatternSet instrPatternSet = AntInstrUtils.calcInstrPatternSet(this.project);
            List<FileSet> instrFileSetsList = AntInstrUtils.calcInstrFileSets(this.project);
            HashSet<File> compileSet = new HashSet<File>(Arrays.asList(this.javac.compileList));
            HashSet<File> copySet = new HashSet<File>(compileSet);
            HashSet<File> instrSet = new HashSet<File>();
            AntInstrUtils.sieveSourceForInstrumentation(this.project, this.javac.getSrcdir(), instrPatternSet, instrFileSetsList, compileSet, copySet, instrSet);
            TestDetector testDetector = this.calcTestDetector(compileSet, copySet, instrSet);
            if (testDetector != null) {
                instrConfig.setTestDetector(testDetector);
            }
            HashSet<File> replacementCompileSet = new HashSet<File>(copySet);
            try {
                this.tmpDir = AntInstrUtils.createInstrDir(instrConfig.getTmpDir());
                Instrumenter instrumenter = new Instrumenter(this.log, instrConfig);
                instrumenter.startInstrumentation();
                for (File f : instrSet) {
                    File copy = instrumenter.instrument(f, this.tmpDir, instrConfig.getEncoding());
                    replacementCompileSet.add(copy);
                }
                instrumenter.endInstrumentation();
                this.javac.compileList = replacementCompileSet.toArray(new File[replacementCompileSet.size()]);
            }
            catch (CloverException e) {
                this.error = e;
                this.log.error(this.error.getMessage());
                this.log.error("** Error(s) occurred and the instrumentation process can't continue.");
                AntInstrUtils.cleanUpInstrDir(this.tmpDir, this.preserveInstr);
            }
            String cloverPathStr = ClassPathUtil.getCloverJarPath();
            if (cloverPathStr != null) {
                Path cloverPath = new Path(this.project, cloverPathStr);
                this.javac.setClasspath(cloverPath);
            }
        } else {
            this.log.info("** Clover is disabled. Delegating straight to the compiler.");
        }
        this.compilerVersionFiddler.push();
        this.underlyingCompiler.setJavac(this.javac);
        this.compilerVersionFiddler.pop();
        this.javacLogging();
    }

    private TestDetector calcTestDetector(Set<File> compileSet, Collection<File> copySet, Collection<File> instrSet) {
        AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(this.project);
        if (config != null && config.getTestSources() != null) {
            FileMappedTestDetector fileMappedTestDetector = new FileMappedTestDetector();
            List<TestSourceSet> testSourcesList = config.getTestSources();
            for (TestSourceSet testSourceSet : testSourcesList) {
                Set<File> included = testSourceSet.getIncludedFiles();
                for (File inc : included) {
                    if (!compileSet.contains(inc)) continue;
                    instrSet.add(inc);
                    copySet.remove(inc);
                }
                Set<File> excluded = testSourceSet.getExcludedFiles();
                for (File exc : excluded) {
                    if (!compileSet.contains(exc)) continue;
                    instrSet.remove(exc);
                    copySet.add(exc);
                }
                fileMappedTestDetector.addTestSourceMatcher(testSourceSet);
            }
            return fileMappedTestDetector;
        }
        return null;
    }

    public static String getDefaultAntCompiler() {
        if (JavaEnvUtils.getJavaVersion().equals("1.1") || JavaEnvUtils.getJavaVersion().equals("1.2")) {
            return "classic";
        }
        return "modern";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws BuildException {
        this.cloverLogging();
        if (this.error != null) {
            Throwable cause = this.error;
            if (this.error.getCause() != null) {
                cause = this.error.getCause();
            }
            throw new BuildException(cause);
        }
        try {
            this.log.debug("delegating to compiler impl: " + this.underlyingCompiler.getClass().getName());
            this.javacLogging();
            this.compilerVersionFiddler.push();
            boolean retval = this.underlyingCompiler.execute();
            this.compilerVersionFiddler.pop();
            boolean bl = retval;
            return bl;
        }
        finally {
            this.cloverLogging();
            AntInstrUtils.cleanUpInstrDir(this.tmpDir, this.preserveInstr);
            this.javacLogging();
        }
    }

    class CompilerVersionFiddler {
        private String ourCompilerStr = null;

        CompilerVersionFiddler() {
        }

        void push() {
            try {
                this.ourCompilerStr = CloverCompilerAdapter.this.javac.getCompilerVersion();
                CloverCompilerAdapter.this.javac.setCompiler(CloverCompilerAdapter.this.compilerDelegate);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }

        void pop() {
            if (this.ourCompilerStr != null) {
                try {
                    CloverCompilerAdapter.this.javac.setCompiler(this.ourCompilerStr);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            this.ourCompilerStr = null;
        }
    }
}

