/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class SourceScanner {
    private final File srcDir;
    private final File destDir;
    private final FilenameFilter nameSpecFilter;

    public SourceScanner(File srcDir, String nameSpec) {
        this(srcDir, null, nameSpec);
    }

    public SourceScanner(File srcDir, File destDir, final String nameSpec) {
        this.srcDir = srcDir;
        this.destDir = destDir;
        this.nameSpecFilter = new FilenameFilter(){

            public boolean accept(File parent, String name) {
                File file = new File(parent, name);
                return file.isDirectory() || name.matches(nameSpec);
            }
        };
    }

    public void visit(Visitor visitor) throws IOException {
        this.scan(null, visitor);
    }

    private void scan(String path, Visitor visitor) throws IOException {
        File dest;
        File src;
        if (path == null) {
            src = this.srcDir;
            dest = this.destDir;
        } else {
            src = new File(this.srcDir, path);
            File file = dest = this.destDir != null ? new File(this.destDir, path) : null;
        }
        if (!src.isDirectory()) {
            return;
        }
        String[] srcFiles = src.list(this.nameSpecFilter);
        String[] destFiles = dest != null ? dest.list(this.nameSpecFilter) : null;
        HashSet<String> destFileSet = new HashSet<String>(destFiles != null ? Arrays.asList(destFiles) : Collections.EMPTY_LIST);
        for (int i = 0; i < srcFiles.length; ++i) {
            String name = srcFiles[i];
            String filePath = path == null ? name : path + "/" + name;
            File file = new File(this.srcDir, filePath);
            if (!file.isDirectory()) {
                if (destFileSet.contains(file)) {
                    destFileSet.remove(file);
                    this.visitCommon(filePath, visitor);
                    continue;
                }
                this.visitOnlyInSrc(filePath, visitor);
                continue;
            }
            this.scan(filePath, visitor);
        }
        for (String s : destFileSet) {
            this.visitOnlyInDest(s, visitor);
        }
    }

    private void visitOnlyInDest(String path, Visitor visitor) throws IOException {
        visitor.onlyInDest(path);
    }

    private void visitOnlyInSrc(String path, Visitor visitor) throws IOException {
        visitor.onlyInSrc(path);
    }

    private void visitCommon(String path, Visitor visitor) throws IOException {
        visitor.common(path);
    }

    public static class SrcFileVisitor
    implements Visitor {
        public void visitSrcFile(String path) throws IOException {
        }

        public void onlyInSrc(String path) throws IOException {
            this.visitSrcFile(path);
        }

        public void common(String path) throws IOException {
        }

        public void onlyInDest(String path) throws IOException {
        }
    }

    public static interface Visitor {
        public void common(String var1) throws IOException;

        public void onlyInSrc(String var1) throws IOException;

        public void onlyInDest(String var1) throws IOException;
    }
}

