/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.remote;

import com.atlassian.clover.Logger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class InitStringData
implements Serializable {
    private final Map<String, String> initStringMap = new HashMap<String, String>();

    public InitStringData(String initString) {
        StringTokenizer tok = new StringTokenizer(initString, ";");
        while (tok.hasMoreTokens()) {
            String keyValue = tok.nextToken();
            String[] pair = keyValue.split("=");
            if (pair.length != 2) {
                throw new IllegalArgumentException("Invalid key=value pair, '" + keyValue + "'  for initString: " + initString);
            }
            this.initStringMap.put(pair[0].trim(), pair[1].trim());
        }
    }

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = this.initStringMap.get(key);
        return value == null ? defaultValue : value;
    }

    public int get(String key, int defaultValue) {
        String value = this.initStringMap.get(key);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            Logger.getInstance().warn("Value for key: " + key + " not a number: " + value + " - " + e.getMessage());
            return defaultValue;
        }
    }

    public boolean get(String key, boolean defaultValue) {
        String value = this.initStringMap.get(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public void set(String key, boolean value) {
        this.initStringMap.put(key, Boolean.toString(value));
    }

    public void set(String key, String value) {
        this.initStringMap.put(key, value);
    }

    public void set(String key, int value) {
        this.set(key, Integer.toString(value));
    }

    public String toString() {
        TreeSet<String> keys = new TreeSet<String>(this.initStringMap.keySet());
        String initString = "";
        for (String key : keys) {
            initString = initString + (initString.length() > 0 ? ";" : "") + key + "=" + this.initStringMap.get(key);
        }
        return initString;
    }
}

