/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.CloverRegistryException;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.RegContents;
import com.atlassian.clover.registry.format.RegContentsConsumer;
import com.atlassian.clover.registry.format.UpdatableRegFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class UpdatableRegFilePrinter {
    public static void printFile(File registryFile, final Writer out) throws CloverException, IOException {
        UpdatableRegFile regFile = new UpdatableRegFile(registryFile);
        out.write("Registry name=" + regFile.getName() + " version=" + regFile.getVersion() + " \n");
        regFile.readContents(new RegContentsConsumer(){

            public void consume(RegContents contents) throws IOException, CloverRegistryException {
                for (InstrSessionSegment sessionSegment : contents.getSessions()) {
                    out.write("\tSession startTs=" + sessionSegment.getStartTs() + " endTs=" + sessionSegment.getEndTs() + " version=" + sessionSegment.getVersion() + "\n");
                    for (FileInfoRecord fileInfoRec : sessionSegment.getFileInfoRecords()) {
                        out.write("\t\tFile name=" + fileInfoRec.getName() + " package=" + fileInfoRec.getPackageName() + "\n");
                    }
                }
                out.flush();
            }
        });
    }

    public static void printFile(File registryFile) throws IOException, CloverException {
        UpdatableRegFilePrinter.printFile(registryFile, new OutputStreamWriter(System.out));
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            UpdatableRegFilePrinter.printUsage();
        } else {
            try {
                UpdatableRegFilePrinter.printFile(new File(args[0]));
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            catch (CloverException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java -cp clover.jar com.atlassian.clover.registry.format.UpdatableRegFilePrinter <clover.db>");
    }
}

