/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.recorder.BaseCoverageRecording;
import com.atlassian.clover.recorder.FOSFactory;
import com.atlassian.clover.recorder.LiveGlobalCoverageRecording;
import com.atlassian.clover.util.CoverageUtils;
import com.atlassian.clover.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class FileBasedGlobalCoverageRecording
extends BaseCoverageRecording
implements LiveGlobalCoverageRecording {
    static final Class[] REQUIRED_CLASSES = new Class[]{IOException.class, DataOutputStream.class, OutputStream.class, FileNotFoundException.class, BufferedOutputStream.class, FileOutputStream.class, Deflater.class, DeflaterOutputStream.class, FOSFactory.class, FOSFactory.REQUIRED_CLASSES.getClass(), BaseCoverageRecording.Header.class, File.class, FileUtils.getInstance().getClass(), CoverageUtils.class, ArrayIndexOutOfBoundsException.class};
    private static final boolean USE_RLE_COMPRESSION = Boolean.valueOf(System.getProperty("clover.rle.coverage", Boolean.TRUE.toString()));
    private final int[][] elements;
    private final int numElements;

    public FileBasedGlobalCoverageRecording(String path, long dbVersion, long timeStamp, int[][] elements, int numElements) {
        super(new BaseCoverageRecording.Header(dbVersion, timeStamp, 0), new File(path));
        this.elements = elements;
        this.numElements = numElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write() throws IOException {
        File file = this.createCoverageFolderFor(this.fileOnDisk);
        DataOutputStream out = new DataOutputStream(FileUtils.createDeflateOutputStream(file));
        try {
            this.header.write(out);
            out.writeInt(this.numElements);
            if (USE_RLE_COMPRESSION) {
                CoverageUtils.rleCompressAndWriteCoverage(out, this.elements, this.numElements);
            } else {
                CoverageUtils.writeUncompressedCoverage(out, this.elements, this.numElements);
            }
            out.flush();
        }
        finally {
            FileUtils.close(out);
        }
        return file.getAbsolutePath();
    }

    static void flushToDisk(String dbname, long dbversion, long writeTS, int[] elements) throws IOException {
        new FileBasedGlobalCoverageRecording(dbname, dbversion, writeTS, new int[][]{elements}, elements.length).write();
    }
}

