/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.recorder.pertest.SnifferType;
import com_cenqua_clover.CloverProfile;
import com_cenqua_clover.CloverVersionInfo;
import com_cenqua_clover.CoverageRecorder;
import com_cenqua_clover.TestNameSniffer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderInstrEmitter
extends Emitter {
    public static final String LAMBDA_INC_METHOD = "lambdaInc";
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.";
    private static final String DEFAULT_CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private static final String UNEXPECTED_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because of an unexpected error.";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    private boolean testClass;
    private boolean isSpockTestClass;
    private boolean isParameterizedJUnitTestClass;
    private String distributedConfig;
    private String classNotFoundMsg;
    private boolean shouldEmitWarningMethod;
    private List<CloverProfile> profiles;
    private boolean isJava18OrHigher;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    @Override
    public void init(InstrumentationState state) {
        this.recorderCfg = RecorderInstrEmitter.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.distributedConfig = state.getCfg().getDistributedConfigString();
        this.profiles = state.getCfg().getProfiles();
        this.registryVersion = state.getSession().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
        this.isJava18OrHigher = state.getCfg().isJava18();
        this.testClass = state.isDetectTests();
        this.isSpockTestClass = state.isSpockTestClass();
        this.isParameterizedJUnitTestClass = state.isParameterizedJUnitTestClass();
        this.classNotFoundMsg = state.getCfg().getClassNotFoundMsg() != null ? state.getCfg().getClassNotFoundMsg() : DEFAULT_CLASSNOTFOUND_MSG;
        boolean bl = this.shouldEmitWarningMethod = !state.hasInstrumented();
        if (!state.hasInstrumented()) {
            state.setHasInstrumented(true);
        }
    }

    @Override
    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            instrString = (this.testClass ? "" : "public ") + "static class " + recorderBase + "{";
            instrString = instrString + "public static " + CoverageRecorder.class.getName() + " " + recorderSuffix + ";";
            instrString = instrString + RecorderInstrEmitter.generateCloverProfilesField(this.profiles);
            if (this.isJava18OrHigher) {
                instrString = instrString + this.generateLambdaIncMethod(recorderSuffix);
            }
            instrString = instrString + "static{";
            instrString = instrString + CoverageRecorder.class.getName() + " _" + recorderSuffix + "=null;";
            if (this.reportInitErrors) {
                instrString = instrString + "try{" + (this.shouldEmitWarningMethod ? Bindings.$CloverVersionInfo$oldVersionInClasspath() + ";" : "") + "if(" + CloverVersionInfo.getBuildStamp() + "L!=" + Bindings.$CloverVersionInfo$getBuildStamp() + ")" + "{" + Bindings.$Clover$l("\"[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.\"") + ";" + Bindings.$Clover$l("\"[CLOVER] WARNING: Instr=" + CloverVersionInfo.getReleaseNum() + "#" + CloverVersionInfo.getBuildStamp() + ",Runtime=\"+" + Bindings.$CloverVersionInfo$getReleaseNum() + "+\"#\"+" + Bindings.$CloverVersionInfo$getBuildStamp()) + ";}";
            }
            instrString = instrString + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = instrString + "_" + recorderSuffix + "=" + Bindings.$Clover$getNullRecorder() + ";";
            instrString = instrString + "_" + recorderSuffix + "=" + Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), this.registryVersion + "L", this.recorderCfg + "L", Integer.toString(this.maxDataIndex), "profiles", "new " + this.javaLangPrefix + "String[]{\"" + "clover.distributed.coverage" + "\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}") + ";";
            if (this.reportInitErrors) {
                instrString = instrString + "}catch(" + this.javaLangPrefix + "SecurityException e){" + this.javaLangPrefix + "System.err.println(\"" + "[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required." + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = instrString + "}catch(" + this.javaLangPrefix + "NoClassDefFoundError e){" + this.javaLangPrefix + "System.err.println(\"" + this.classNotFoundMsg + " (\"+e.getClass()+\":\"+e.getMessage()+\")\");";
                instrString = instrString + "}catch(" + this.javaLangPrefix + "Throwable t){" + this.javaLangPrefix + "System.err.println(\"" + UNEXPECTED_MSG + " (\"+t.getClass()+\":\"+t.getMessage()+\")\");}";
            }
            instrString = instrString + recorderSuffix + "=" + "_" + recorderSuffix + ";";
            instrString = instrString + "}}";
            if (this.testClass) {
                instrString = instrString + RecorderInstrEmitter.generateTestSnifferField(this.isSpockTestClass, this.isParameterizedJUnitTestClass);
            }
        } else {
            instrString = "public static " + CoverageRecorder.class.getName() + " " + this.recorderPrefix + "=" + Bindings.$Clover$getRecorder(RecorderInstrEmitter.asUnicodeString(this.initString), this.registryVersion + "L", this.recorderCfg + "L", Integer.toString(this.maxDataIndex), RecorderInstrEmitter.generateCloverProfilesInline(this.profiles), "new " + this.javaLangPrefix + "String[]{\"" + "clover.distributed.coverage" + "\"," + RecorderInstrEmitter.asUnicodeString(this.distributedConfig) + "}") + ";";
            if (this.testClass) {
                instrString = instrString + RecorderInstrEmitter.generateTestSnifferField(this.isSpockTestClass, this.isParameterizedJUnitTestClass);
            }
        }
        return instrString;
    }

    static String generateTestSnifferField(boolean isSpock, boolean isParamJUnit) {
        return RecorderInstrEmitter.generateTestSnifferField(isSpock ? SnifferType.SPOCK : (isParamJUnit ? SnifferType.JUNIT : SnifferType.NULL));
    }

    static String generateTestSnifferField(SnifferType snifferType) {
        String snifferField = "public static final " + TestNameSniffer.class.getName() + " " + "__CLR3_3_0_TEST_NAME_SNIFFER";
        switch (snifferType) {
            case JUNIT: {
                return snifferField + "=new com_cenqua_clover.JUnitParameterizedTestSniffer();";
            }
            case SPOCK: {
                return snifferField + "=new com_cenqua_clover.SpockFeatureNameSniffer();";
            }
        }
        return snifferField + "=" + TestNameSniffer.class.getName() + ".NULL_INSTANCE;";
    }

    private String generateLambdaIncMethod(String recorderSuffix) {
        StringBuilder str = new StringBuilder();
        str.append("@java.lang.SuppressWarnings(\"unchecked\") ");
        str.append("public static <I, T extends I> I ").append(LAMBDA_INC_METHOD).append("(final int i,final T l,final int si){");
        str.append("java.lang.reflect.InvocationHandler h=new java.lang.reflect.InvocationHandler(){");
        str.append("public ").append(this.javaLangPrefix).append("Object invoke(");
        str.append(this.javaLangPrefix).append("Object p,java.lang.reflect.Method m,").append(this.javaLangPrefix).append("Object[] a) ");
        str.append("throws Throwable{");
        str.append(recorderSuffix).append(".inc(i);");
        str.append(recorderSuffix).append(".inc(si);");
        str.append("try{return m.invoke(l,a);}catch(java.lang.reflect.InvocationTargetException e){");
        str.append("throw e.getCause()!=null?e.getCause():new RuntimeException(\"Clover failed to invoke instrumented lambda\",e);");
        str.append("}}};");
        str.append("return (I)java.lang.reflect.Proxy.newProxyInstance(l.getClass().getClassLoader(),l.getClass().getInterfaces(),h);");
        str.append("}");
        return str.toString();
    }

    static String generateCloverProfilesField(List<CloverProfile> profiles) {
        String str = "public static " + CloverProfile.class.getName() + "[] profiles = { ";
        str = str + RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles);
        str = str + "};";
        return str;
    }

    public static String generateCloverProfilesInline(List<CloverProfile> profiles) {
        return "new " + CloverProfile.class.getName() + "[] {" + RecorderInstrEmitter.generateCloverProfilesNewInstances(profiles) + "}";
    }

    private static String generateCloverProfilesNewInstances(List<CloverProfile> profiles) {
        String str = "";
        if (profiles != null) {
            Iterator<CloverProfile> iter = profiles.iterator();
            while (iter.hasNext()) {
                CloverProfile profile = iter.next();
                str = str + "new " + CloverProfile.class.getName() + "(";
                str = str + RecorderInstrEmitter.asUnicodeString(profile.getName()) + ", ";
                str = str + "\"" + (Object)((Object)profile.getCoverageRecorder()) + "\", ";
                str = profile.getDistributedCoverage() != null ? str + RecorderInstrEmitter.asUnicodeString(profile.getDistributedCoverage().getConfigString()) + ")" : str + "null)";
                if (!iter.hasNext()) continue;
                str = str + ",";
            }
        }
        return str;
    }

    public static String asUnicodeString(String str) {
        if (str == null) {
            return "null";
        }
        String res = "\"";
        for (char c : str.toCharArray()) {
            res = c == '\\' ? res + String.format(Locale.US, "\\u%04x\\u%04x", (int)c, (int)c) : res + String.format(Locale.US, "\\u%04x", (int)c);
        }
        res = res + "\"";
        return res;
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    private static long getConfigBits(InstrumentationConfig cfg) {
        return CoverageRecorder.getConfigBits(cfg.getFlushPolicy(), cfg.getFlushInterval(), false, false, !cfg.isSliceRecording());
    }
}

