/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.types;

import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AbstractAntLogger;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.DataType;

public abstract class BaseCloverOptimizedType
extends DataType {
    protected File snapshotFile;
    protected OptimizationOptions.Builder optionsBuilder = new OptimizationOptions.Builder().optimizableName("class");

    public void setDebug(boolean debug) {
        this.optionsBuilder.debug(debug);
    }

    public void setEnabled(boolean enabled) {
        this.optionsBuilder.enabled(enabled);
    }

    public void setSnapshotFile(File snapshotFile) {
        this.snapshotFile = snapshotFile;
    }

    public void setLogger(Logger logger) {
        this.optionsBuilder.logger(logger);
    }

    public void setFullRunEvery(int fullRunEvery) {
        this.optionsBuilder.maxCompilesBeforeStaleSnapshot(fullRunEvery);
    }

    protected Logger takeOverLogging(Project project) {
        Logger originalLogger = Logger.getInstance();
        Logger logger = this.optionsBuilder.build().getLogger();
        if (logger == null) {
            final Task currentTask = project.getThreadTask(Thread.currentThread());
            logger = new AbstractAntLogger(project){

                public Task getTask() {
                    return currentTask;
                }
            };
        }
        Logger.setInstance(logger);
        return originalLogger;
    }

    protected Logger revertLogger(Logger logger) {
        Logger orig = Logger.getInstance();
        Logger.setInstance(logger);
        return orig;
    }

    protected static String normalizePath(String resourcePath) {
        if ((resourcePath = resourcePath.replaceAll("\\\\", "/")).endsWith(".class")) {
            int dollarIndex = resourcePath.lastIndexOf("$");
            if (dollarIndex == -1) {
                return resourcePath.substring(0, resourcePath.length() - ".class".length()) + ".java";
            }
            return resourcePath.substring(0, dollarIndex) + ".java";
        }
        return resourcePath;
    }
}

