/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.xy;

import clover.org.jfree.chart.HashUtilities;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.XYToolTipGenerator;
import clover.org.jfree.chart.plot.CrosshairState;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.xy.XYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRendererState;
import clover.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import clover.org.jfree.chart.urls.XYURLGenerator;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class XYStepRenderer
extends XYLineAndShapeRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8918141928884796108L;
    private double stepPoint = 1.0;

    public XYStepRenderer() {
        this(null, null);
    }

    public XYStepRenderer(XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setBaseToolTipGenerator(toolTipGenerator);
        this.setURLGenerator(urlGenerator);
        this.setBaseShapesVisible(false);
    }

    public double getStepPoint() {
        return this.stepPoint;
    }

    public void setStepPoint(double stepPoint) {
        if (stepPoint < 0.0 || stepPoint > 1.0) {
            throw new IllegalArgumentException("Requires stepPoint in [0.0;1.0]");
        }
        this.stepPoint = stepPoint;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double transY1;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        Paint seriesPaint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double d = transY1 = Double.isNaN(y1) ? Double.NaN : rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (item > 0) {
            double transY0;
            double x0 = dataset.getXValue(series, item - 1);
            double y0 = dataset.getYValue(series, item - 1);
            double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
            double d2 = transY0 = Double.isNaN(y0) ? Double.NaN : rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
            if (orientation == PlotOrientation.HORIZONTAL) {
                if (transY0 == transY1) {
                    this.drawLine(g2, state.workingLine, transY0, transX0, transY1, transX1);
                } else {
                    double transXs = transX0 + this.getStepPoint() * (transX1 - transX0);
                    this.drawLine(g2, state.workingLine, transY0, transX0, transY0, transXs);
                    this.drawLine(g2, state.workingLine, transY0, transXs, transY1, transXs);
                    this.drawLine(g2, state.workingLine, transY1, transXs, transY1, transX1);
                }
            } else if (orientation == PlotOrientation.VERTICAL) {
                if (transY0 == transY1) {
                    this.drawLine(g2, state.workingLine, transX0, transY0, transX1, transY1);
                } else {
                    double transXs = transX0 + this.getStepPoint() * (transX1 - transX0);
                    this.drawLine(g2, state.workingLine, transX0, transY0, transXs, transY0);
                    this.drawLine(g2, state.workingLine, transXs, transY0, transXs, transY1);
                    this.drawLine(g2, state.workingLine, transXs, transY1, transX1, transY1);
                }
            }
        }
        if (this.isItemLabelVisible(series, item)) {
            double xx = transX1;
            double yy = transY1;
            if (orientation == PlotOrientation.HORIZONTAL) {
                xx = transY1;
                yy = transX1;
            }
            this.drawItemLabel(g2, orientation, dataset, series, item, xx, yy, y1 < 0.0);
        }
        int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
        int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
        this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, rangeAxisIndex, transX1, transY1, orientation);
        EntityCollection entities = state.getEntityCollection();
        if (entities != null) {
            this.addEntity(entities, null, dataset, series, item, transX1, transY1);
        }
    }

    private void drawLine(Graphics2D g2, Line2D line, double x0, double y0, double x1, double y1) {
        if (Double.isNaN(x0) || Double.isNaN(x1) || Double.isNaN(y0) || Double.isNaN(y1)) {
            return;
        }
        line.setLine(x0, y0, x1, y1);
        g2.draw(line);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        XYStepRenderer that = (XYStepRenderer)obj;
        if (this.stepPoint != that.stepPoint) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return HashUtilities.hashCode(super.hashCode(), this.stepPoint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

